/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.gamemode;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.addons.packutils.bukkit.methods.GamemodeMethods;
import fr.ulity.core.api.CommandManager;
import fr.ulity.core.api.Lang;
import java.util.Arrays;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class GamemodeCommand
extends CommandManager.Assisted {
    public GamemodeCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "gamemode");
        this.addPermission("ulity.packutils.gamemode");
        this.addAliases(new String[]{"gm"});
        this.addListTabbComplete(0, null, null, Arrays.asList(Lang.get((String)"packutils.gamemode.type.creative"), Lang.get((String)"packutils.gamemode.type.survival"), Lang.get((String)"packutils.gamemode.type.adventure"), Lang.get((String)"packutils.gamemode.type.spectator")).toArray(new String[0]));
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            this.registerCommand(commandMap);
        }
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        if (this.arg.inRange(1, 2)) {
            Player target = null;
            if (this.arg.is(2)) {
                if (this.requirePermission("ulity.packutils.gamemode.others") && this.arg.requirePlayer(1)) {
                    target = this.arg.getPlayer(1);
                }
            } else if (this.requirePlayer()) {
                target = (Player)sender;
            }
            if (this.status.equals((Object)CommandManager.Assisted.Status.SUCCESS)) {
                if (this.arg.compare(args[0], new String[]{"0", Lang.get((String)"packutils.gamemode.type.survival")})) {
                    GamemodeMethods.define(target, GameMode.SURVIVAL, sender);
                } else if (this.arg.compare(args[0], new String[]{"1", Lang.get((String)"packutils.gamemode.type.creative")})) {
                    GamemodeMethods.define(target, GameMode.CREATIVE, sender);
                } else if (this.arg.compare(args[0], new String[]{"2", Lang.get((String)"packutils.gamemode.type.adventure")})) {
                    GamemodeMethods.define(target, GameMode.ADVENTURE, sender);
                } else if (this.arg.compare(args[0], new String[]{"3", Lang.get((String)"packutils.gamemode.type.spectator")})) {
                    GamemodeMethods.define(target, GameMode.SPECTATOR, sender);
                } else {
                    this.setStatus(CommandManager.Assisted.Status.SYNTAX);
                }
            }
        } else {
            this.setStatus(CommandManager.Assisted.Status.SYNTAX);
        }
    }
}

