/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.economy;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.addons.packutils.bukkit.methods.EconomyMethods;
import fr.ulity.core.api.CommandManager;
import fr.ulity.core.api.Lang;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class EcoCommand
extends CommandManager.Assisted {
    public EcoCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "eco");
        this.addPermission("ulity.packutils.eco");
        this.addArrayTabbComplete(0, null, new String[0], new String[]{"set", "add", "remove"});
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            this.registerCommand(commandMap);
        }
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        if (this.arg.get(0).equals("clear")) {
            EconomyMethods.money.clear();
            Lang.prepare((String)"commands.eco.expressions.all_accounts_cleared").sendPlayer(sender);
        } else if (this.arg.is(0) && this.arg.requirePlayer(1)) {
            Player playerHandle = this.arg.getPlayer(1);
            if (args[0].equalsIgnoreCase("set") && this.arg.requireNumber(2)) {
                EconomyMethods.money.set("player." + playerHandle.getName(), (Object)Double.parseDouble(args[2]));
                if (!sender.getName().equals(playerHandle.getName())) {
                    Lang.prepare((String)"commands.eco.expressions.sender.sold_set").variable("player", playerHandle.getName()).variable("money", args[2]).sendPlayer(sender);
                }
                Lang.prepare((String)"commands.eco.expressions.player.sold_set").variable("money", args[2]).sendPlayer(playerHandle);
            } else if (args[0].equalsIgnoreCase("add") && this.arg.requireNumber(2)) {
                new EconomyMethods().depositPlayer(playerHandle.getName(), Double.parseDouble(args[2]));
                if (!sender.getName().equals(playerHandle.getName())) {
                    Lang.prepare((String)"commands.eco.expressions.sender.sold_added").variable("player", playerHandle.getName()).variable("added", args[2]).sendPlayer(sender);
                }
                Lang.prepare((String)"commands.eco.expressions.player.sold_added").variable("added", args[2]).sendPlayer(playerHandle);
            } else if (args[0].equalsIgnoreCase("remove") && this.arg.requireNumber(2)) {
                new EconomyMethods().withdrawPlayer(playerHandle.getName(), Double.parseDouble(args[2]));
                if (!sender.getName().equals(playerHandle.getName())) {
                    Lang.prepare((String)"commands.eco.expressions.sender.sold_taked").variable("player", playerHandle.getName()).variable("taked", args[2]).sendPlayer(sender);
                }
                Lang.prepare((String)"commands.eco.expressions.player.sold_taked").variable("taked", args[2]).sendPlayer(playerHandle);
            } else {
                this.setStatus(CommandManager.Assisted.Status.SYNTAX);
            }
        }
    }
}

