/*
 * Decompiled with CFR 0.152.
 */
package me.tekcno.antialtglobal.listeners;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import me.tekcno.antialtglobal.AntiAlt;
import me.tekcno.antialtglobal.PlayerStatus;
import me.tekcno.antialtglobal.db.Database;
import me.tekcno.antialtglobal.rest.RestConnector;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoinListener
implements Listener {
    public AntiAlt plugin;
    public Connection conn;

    public PlayerJoinListener(AntiAlt plugin) {
        this.plugin = plugin;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        try {
            this.conn = Database.getConnection("logs.db");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.plugin.getLogger().info("Player Joined");
        Player player = e.getPlayer();
        this.log(player.getName(), player.getAddress().getHostName());
        int related = this.relatedAccounts(player.getAddress().getHostName());
        Map<String, Integer> alt = RestConnector.detect(player.getName());
        boolean possibleAlt = alt.get("possible_alt") == 1;
        boolean confirmedAlt = alt.get("confirmed_alt") == 1;
        int occurrences = alt.get("occurrences");
        int confirmedOccurrences = alt.get("confirmed_occurrences");
        if (!this.plugin.getConfig().getBoolean("antialt.show_possible_alts")) {
            possibleAlt = false;
        }
        if (related > this.plugin.getConfig().getInt("antialt.alt_threshold") || confirmedAlt || possibleAlt) {
            if (this.plugin.getConfig().getBoolean("antialt.api_enabled")) {
                RestConnector.report(player, this.getUniqueId(), this.plugin.getConfig().getString("antialt.key"));
                this.plugin.getLogger().info(this.plugin.getConfig().getString("antialt.key"));
            } else {
                RestConnector.report(player, this.getUniqueId());
            }
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (!p.hasPermission("antialt.messages") || !PlayerStatus.getPlayerStatus(p)) continue;
                TextComponent message = new TextComponent(confirmedAlt ? "[AntiAlt] Alt Detected" : "[AntiAlt] Possible Alt Detected");
                TextComponent hover = new TextComponent(" [Hover for details]");
                message.setColor(ChatColor.RED);
                hover.setColor(ChatColor.GRAY);
                hover.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("The user " + player.getName() + " has been flagged " + occurrences + " times as an alt on other servers. They have been flagged " + confirmedOccurrences + " times by trusted servers.").create()));
                message.addExtra((BaseComponent)hover);
                p.spigot().sendMessage((BaseComponent)message);
            }
        }
    }

    public int relatedAccounts(String ip) {
        String sql = "SELECT COUNT(username) AS cnt FROM log WHERE ip = ?";
        try {
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ps.setString(1, ip);
            ResultSet alts = ps.executeQuery();
            int count = alts.getInt("cnt");
            alts.close();
            return count;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Unable to fetch related accounts: " + e.getMessage());
            return 0;
        }
    }

    public String getUniqueId() {
        ResultSet alts;
        Statement s;
        block3: {
            String sql = "SELECT ip FROM log WHERE username='-'";
            try {
                s = this.conn.createStatement();
                alts = s.executeQuery(sql);
                if (alts.next()) break block3;
                this.plugin.getLogger().warning("No results");
                alts.close();
                s.close();
                return null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.plugin.getLogger().warning("Unable to get row(s): " + e.getMessage());
                return null;
            }
        }
        String str = alts.getString("ip");
        alts.close();
        s.close();
        return str;
    }

    public void log(String username, String ip) {
        String sql = "INSERT INTO log (username, ip) SELECT ?, ? WHERE NOT EXISTS (SELECT 1 FROM log WHERE username = ? AND ip = ?)";
        try {
            PreparedStatement pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, username);
            pstmt.setString(2, ip);
            pstmt.setString(3, username);
            pstmt.setString(4, ip);
            pstmt.executeUpdate();
            pstmt.close();
            this.plugin.getLogger().info("Logged Player");
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Unable to insert row: " + e.getMessage());
        }
    }
}

