/*
 * Decompiled with CFR 0.152.
 */
package xyz.mackan.ChatItems.util;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;
import xyz.mackan.ChatItems.ChatItems;
import xyz.mackan.ChatItems.ChatItemsAPI;
import xyz.mackan.ChatItems.util.IItemUtil;
import xyz.mackan.ItemNames.ItemNames;

public class ItemUtil
implements IItemUtil {
    public static String getTranslatableMaterialName(ItemStack item) {
        return ChatItems.getLocaleManager().queryMaterial(item.getType());
    }

    @Nullable
    public static String getItemMetaName(ItemStack item) {
        return ItemUtil.getItemMetaName(item, false);
    }

    public static String getItemMetaName(ItemStack item, boolean returnDefaultName) {
        ItemMeta meta = item.getItemMeta();
        boolean hasItemMeta = item.hasItemMeta();
        if (!hasItemMeta) {
            if (!returnDefaultName) {
                return null;
            }
            return ItemUtil.getItemName(item);
        }
        if (item.getType() == Material.WRITTEN_BOOK) {
            BookMeta bookMeta = (BookMeta)meta;
            return bookMeta.getTitle();
        }
        String displayName = meta.getDisplayName();
        if (displayName == null || displayName.equals("")) {
            return null;
        }
        return displayName;
    }

    @Nullable
    public static String getItemName(ItemStack item) {
        return ItemNames.getItemName(item);
    }

    public static BaseComponent getItemComponent(ItemStack itemStack, String defaultString) {
        TextComponent displayItem;
        if (itemStack == null) {
            return new TextComponent(defaultString);
        }
        int itemAmount = itemStack.getAmount();
        String itemMetaName = ItemUtil.getItemMetaName(itemStack);
        String translatableName = ItemUtil.getTranslatableMaterialName(itemStack);
        if (itemMetaName != null) {
            String displayName = itemMetaName;
            if (itemAmount == 1 && ChatItems.configHolder.singleItems) {
                displayName = "1 x " + itemMetaName;
            }
            if (itemAmount > 1 && ChatItems.configHolder.multiple) {
                displayName = itemAmount + " x " + itemMetaName;
            }
            displayItem = new TextComponent(displayName);
        } else {
            TextComponent itemComponent = new TextComponent("");
            if (itemAmount == 1 && ChatItems.configHolder.singleItems) {
                itemComponent = new TextComponent("1 x ");
            }
            if (itemAmount > 1 && ChatItems.configHolder.multiple) {
                itemComponent = new TextComponent("" + itemAmount + " x ");
            }
            itemComponent.addExtra((BaseComponent)new TranslatableComponent(translatableName, new Object[0]));
            displayItem = itemComponent;
        }
        ChatItemsAPI api = ChatItems.getApi();
        String itemJson = api.convertItemStackToJson(itemStack);
        BaseComponent[] hoverEventComponents = new BaseComponent[]{new TextComponent(itemJson)};
        displayItem.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, hoverEventComponents));
        displayItem.setColor(ChatColor.AQUA);
        return displayItem;
    }
}

