/*
 * Decompiled with CFR 0.152.
 */
package xyz.mackan.ChatItems;

import java.util.logging.Level;
import me.pikamug.localelib.LocaleLib;
import me.pikamug.localelib.LocaleManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.mackan.ChatItems.ChatItemsAPI;
import xyz.mackan.ChatItems.commands.ChatItemCommand;
import xyz.mackan.ChatItems.events.PlayerChatEventListener;
import xyz.mackan.ChatItems.types.ChatPattern;
import xyz.mackan.ChatItems.util.ConfigHolder;
import xyz.mackan.ChatItems.util.PatternManager;

public class ChatItems
extends JavaPlugin {
    private static LocaleManager localeManager;
    private static PluginDescriptionFile descriptionFile;
    public static ConfigHolder configHolder;
    private static ChatItemsAPI api;
    public static boolean shouldHandleChat;

    public static LocaleManager getLocaleManager() {
        return localeManager;
    }

    public static PluginDescriptionFile getDescriptionFile() {
        return descriptionFile;
    }

    public static void setHandleChat(boolean handleChat) {
        shouldHandleChat = handleChat;
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        ChatItems.configHolder.multiple = config.getBoolean("showQuantities.multiple", true);
        ChatItems.configHolder.singleItems = config.getBoolean("showQuantities.singleItems", false);
    }

    private void loadAPI() {
        String packageName = ChatItems.class.getPackage().getName();
        String internalsName = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1);
        try {
            api = (ChatItemsAPI)Class.forName(packageName + ".API.ChatItemsAPI_v" + internalsName).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            Bukkit.getLogger().log(Level.SEVERE, "ChatItems could not find a valid implementation for this server version.");
        }
    }

    private void registerDefaultPatterns() {
        PatternManager.registerPattern(ChatPattern.Type.HAND, "\\[item\\]");
        PatternManager.registerPattern(ChatPattern.Type.HAND, "\\[i\\]");
        PatternManager.registerPattern(ChatPattern.Type.HAND, "\\[hand\\]");
        PatternManager.registerPattern(ChatPattern.Type.OFFHAND, "\\[offhand\\]");
        PatternManager.registerPattern(ChatPattern.Type.HELMET, "\\[helmet\\]");
        PatternManager.registerPattern(ChatPattern.Type.HELMET, "\\[helm\\]");
        PatternManager.registerPattern(ChatPattern.Type.HELMET, "\\[head\\]");
        PatternManager.registerPattern(ChatPattern.Type.CHESTPLATE, "\\[chestplate\\]");
        PatternManager.registerPattern(ChatPattern.Type.CHESTPLATE, "\\[chest\\]");
        PatternManager.registerPattern(ChatPattern.Type.LEGS, "\\[legs\\]");
        PatternManager.registerPattern(ChatPattern.Type.BOOTS, "\\[boots\\]");
    }

    public void onEnable() {
        this.getLogger().info("[ChatItems] enabled.");
        this.loadAPI();
        this.saveDefaultConfig();
        this.loadConfig();
        this.registerDefaultPatterns();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatEventListener(), (Plugin)this);
        LocaleLib localeLib = (LocaleLib)this.getServer().getPluginManager().getPlugin("LocaleLib");
        localeManager = localeLib.getLocaleManager();
        this.getCommand("ci").setExecutor((CommandExecutor)new ChatItemCommand());
        descriptionFile = this.getDescription();
    }

    public void onDisable() {
        this.getLogger().info("[ChatItems] is disabled.");
    }

    public static ChatItemsAPI getApi() {
        return api;
    }

    static {
        configHolder = new ConfigHolder();
        shouldHandleChat = true;
    }
}

