/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.localelib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.pikamug.localelib.LocaleKeys;
import org.apache.commons.lang.NullArgumentException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class LocaleManager {
    private static Class<?> craftMagicNumbers = null;
    private static Class<?> itemClazz = null;
    private static Class<?> localeClazz = null;
    private static boolean oldVersion = false;
    private static boolean hasBasePotionData = false;
    private Map<String, String> oldBlocks = LocaleKeys.getBlockKeys();
    private Map<String, String> oldItems = LocaleKeys.getItemKeys();
    private Map<String, String> oldPotions = LocaleKeys.getPotionKeys();
    private Map<String, String> oldLingeringPotions = LocaleKeys.getLingeringPotionKeys();
    private Map<String, String> oldSplashPotions = LocaleKeys.getSplashPotionKeys();
    private Map<String, String> oldEntities = LocaleKeys.getEntityKeys();

    public LocaleManager() {
        oldVersion = this.isBelow113();
        if (Material.getMaterial((String)"LINGERING_POTION") != null) {
            hasBasePotionData = true;
        }
        String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        try {
            craftMagicNumbers = Class.forName("org.bukkit.craftbukkit.{v}.util.CraftMagicNumbers".replace("{v}", version));
            itemClazz = Class.forName("net.minecraft.server.{v}.Item".replace("{v}", version));
            localeClazz = Class.forName("net.minecraft.server.{v}.LocaleLanguage".replace("{v}", version));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean sendMessage(Player player, String message, Material material, short durability, Map<Enchantment, Integer> enchantments, ItemMeta meta) {
        if (player == null || material == null) {
            return false;
        }
        String matKey = "";
        try {
            matKey = this.queryMaterial(material, durability, meta);
        }
        catch (Exception ex) {
            Bukkit.getLogger().severe("[LocaleLib] Unable to query Material: " + material.name());
            return false;
        }
        Collection<String> enchKeys = this.queryEnchantments(enchantments).values();
        String msg = message.replace("<item>", "\",{\"translate\":\"" + matKey + "\"},\"");
        for (String ek : enchKeys) {
            msg.replaceFirst("<enchantment>", "\",{\"translate\":\"" + ek + "\"},\"");
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " [\"" + msg + "\"]"));
        return true;
    }

    public boolean sendMessage(Player player, String message, Material material, short durability, Map<Enchantment, Integer> enchantments) {
        return this.sendMessage(player, message, material, durability, enchantments, null);
    }

    public boolean sendMessage(Player player, String message, Map<Enchantment, Integer> enchantments) {
        if (player == null || message == null || enchantments == null) {
            return false;
        }
        Collection<String> enchKeys = this.queryEnchantments(enchantments).values();
        String msg = message;
        for (String ek : enchKeys) {
            msg.replaceFirst("<enchantment>", "\",{\"translate\":\"" + ek + "\"},\"");
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " [\"" + msg + "\"]"));
        return true;
    }

    public boolean sendMessage(Player player, String message, EntityType type, String extra) {
        if (player == null || message == null || type == null) {
            return false;
        }
        String key = "";
        key = oldVersion ? (type.name().equals("VILLAGER") && Villager.Profession.valueOf((String)extra) != null ? this.oldEntities.get(type.name() + "." + Villager.Profession.valueOf((String)extra).name()) : (type.name().equals("OCELOT") && Ocelot.Type.valueOf((String)extra) != null ? this.oldEntities.get(type.name() + "." + Ocelot.Type.valueOf((String)extra).name()) : (type.name().equals("RABBIT") && Rabbit.Type.valueOf((String)extra) != null && Rabbit.Type.valueOf((String)extra).equals((Object)Rabbit.Type.THE_KILLER_BUNNY) ? this.oldEntities.get(type.name() + "." + Rabbit.Type.valueOf((String)extra).name()) : this.oldEntities.get(type.name())))) : (type.name().equals("PIG_ZOMBIE") ? "entity.minecraft.zombie_pigman" : "entity.minecraft." + type.toString().toLowerCase());
        String msg = message.replace("<mob>", "\",{\"translate\":\"" + key + "\"},\"");
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " [\"" + msg + "\"]"));
        return true;
    }

    public String queryMaterial(Material material) throws IllegalArgumentException, NullArgumentException {
        return this.queryMaterial(material, (short)0, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String queryMaterial(Material material, short durability, ItemMeta meta) throws IllegalArgumentException, NullArgumentException {
        if (material == null) {
            throw new NullArgumentException("[LocaleLib] Material cannot be null");
        }
        String matKey = "";
        if (oldVersion) {
            if (material.isBlock()) {
                if (durability >= 0 && this.oldBlocks.containsKey(material.name() + "." + durability)) {
                    return this.oldBlocks.get(material.name() + "." + durability);
                }
                if (!this.oldBlocks.containsKey(material.name())) throw new IllegalArgumentException("[LocaleLib] Block not found: " + material.name() + "." + durability);
                return this.oldBlocks.get(material.name());
            }
            ItemStack i = new ItemStack(material, 1, durability);
            if (durability >= 0 && i.getItemMeta() instanceof PotionMeta) {
                if (!hasBasePotionData) return matKey;
                if (material.equals((Object)Material.POTION)) {
                    return this.oldPotions.get(((PotionMeta)i.getItemMeta()).getBasePotionData().getType().name());
                }
                if (material.equals((Object)Material.LINGERING_POTION)) {
                    return this.oldLingeringPotions.get(((PotionMeta)i.getItemMeta()).getBasePotionData().getType().name());
                }
                if (!material.equals((Object)Material.SPLASH_POTION)) return matKey;
                return this.oldSplashPotions.get(((PotionMeta)i.getItemMeta()).getBasePotionData().getType().name());
            }
            if (durability >= 0 && this.oldItems.containsKey(material.name() + "." + durability)) {
                return this.oldItems.get(material.name() + "." + durability);
            }
            if (!this.oldItems.containsKey(material.name())) throw new IllegalArgumentException("[LocaleLib] Item not found: " + material.name() + "." + durability);
            return this.oldItems.get(material.name());
        }
        try {
            Object item = null;
            Method m = craftMagicNumbers.getDeclaredMethod("getItem", material.getClass());
            m.setAccessible(true);
            item = m.invoke(craftMagicNumbers, material);
            if (item == null) {
                throw new IllegalArgumentException(material.name() + " material could not be queried!");
            }
            matKey = (String)itemClazz.getMethod("getName", new Class[0]).invoke(item, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("[LocaleLib] Unable to query Material: " + material.name());
        }
        if (meta == null) return matKey;
        if (!(meta instanceof PotionMeta)) return matKey;
        return "item.minecraft.potion.effect." + ((PotionMeta)meta).getBasePotionData().getType().name().toLowerCase().replace("regen", "regeneration").replace("speed", "swiftness").replace("jump", "leaping").replace("instant_heal", "healing").replace("instant_damage", "harming");
    }

    public Map<Enchantment, String> queryEnchantments(Map<Enchantment, Integer> enchantments) {
        HashMap<Enchantment, String> enchKeys = new HashMap<Enchantment, String>();
        if (enchantments == null || enchantments.isEmpty()) {
            return enchKeys;
        }
        if (oldVersion) {
            for (Enchantment e : enchantments.keySet()) {
                enchKeys.put(e, "enchantment." + e.getName().toLowerCase().replace("_", ".").replace("environmental", "all").replace("protection", "protect"));
            }
        } else {
            for (Enchantment e : enchantments.keySet()) {
                enchKeys.put(e, "enchantment.minecraft." + e.toString().toLowerCase());
            }
        }
        return enchKeys;
    }

    public String toServerLocale(String key) throws IllegalAccessException, InvocationTargetException {
        Method trans = (Method)Arrays.stream(localeClazz.getMethods()).filter(m -> m.getReturnType().equals(String.class)).filter(m -> m.getParameterCount() == 1).filter(m -> m.getParameters()[0].getType().equals(String.class)).collect(Collectors.toList()).get(0);
        return (String)trans.invoke(localeClazz, key);
    }

    public boolean hasBasePotionData() {
        return hasBasePotionData;
    }

    public boolean isBelow113() {
        return this._isBelow113(Bukkit.getServer().getBukkitVersion().split("-")[0]);
    }

    private boolean _isBelow113(String bukkitVersion) {
        if (bukkitVersion.matches("^[0-9.]+$")) {
            switch (bukkitVersion) {
                case "1.12.2": 
                case "1.12.1": 
                case "1.12": 
                case "1.11.2": 
                case "1.11.1": 
                case "1.11": 
                case "1.10.2": 
                case "1.10.1": 
                case "1.10": 
                case "1.9.4": 
                case "1.9.3": 
                case "1.9.2": 
                case "1.9.1": 
                case "1.9": 
                case "1.8.9": 
                case "1.8.8": 
                case "1.8.7": 
                case "1.8.6": 
                case "1.8.5": 
                case "1.8.4": 
                case "1.8.3": 
                case "1.8.2": 
                case "1.8.1": 
                case "1.8": 
                case "1.7.10": 
                case "1.7.9": 
                case "1.7.2": {
                    return true;
                }
            }
            return false;
        }
        Bukkit.getLogger().severe("Quests received invalid Bukkit version " + bukkitVersion);
        return false;
    }
}

