/*
 * Decompiled with CFR 0.152.
 */
package org.Gr_Code.CityRoad.Utils;

import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.Gr_Code.CityRoad.CityRoad;
import org.Gr_Code.CityRoad.Managers.ManageHandler;
import org.Gr_Code.CityRoad.Managers.Specific.SetUpManagerData;
import org.Gr_Code.CityRoad.Managers.Specific.Task;
import org.Gr_Code.CityRoad.RoadData.AbstractInfo;
import org.Gr_Code.CityRoad.RoadData.Type.TickManager;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Utils {
    private boolean isEnabled = true;

    public TickManager getTickManager(String paramString) {
        HashSet<TickManager> tickManagers = CityRoad.getInstance().getManageHandler().getTask().getTaskSet();
        TickManager tickManager = tickManagers.stream().filter(x -> x.getDataManager().getUniqueString().equals(paramString)).findFirst().orElse(null);
        return tickManager;
    }

    public UUID spawnArmorStandUUID(Location location, ItemStack itemStack) {
        World world = location.getWorld();
        ArmorStand armorStand = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setBasePlate(false);
        armorStand.setCollidable(false);
        armorStand.setArms(false);
        armorStand.getEquipment().setHelmet(itemStack);
        return armorStand.getUniqueId();
    }

    public String translate(String string) {
        String paramString = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return paramString;
    }

    public void sendMessageSetUp(Player player) {
        player.sendMessage(this.translate("&a----------------------------------"));
        player.sendMessage(this.translate("&6&lPlace the &c&lFirst &6&land &b&lSecond &6&lBlocks."));
        player.sendMessage(this.translate("&c&lHold in the &6&lOff-Hand &c&lItem, which will be the &6&lCabin."));
        player.sendMessage(this.translate("&a----------------------------------"));
    }

    public void addPassenger(ArmorStand armorStand) {
        Location location = armorStand.getLocation();
        Task task = CityRoad.getInstance().getManageHandler().getTask();
        for (Entity entity : armorStand.getNearbyEntities(0.5, 0.5, 0.5)) {
            if (!(entity instanceof Player) || !armorStand.isEmpty() || task.getTaskSet().stream().anyMatch(x -> x.getTickArmorStand().getPassengers().contains(entity)) || entity.isInsideVehicle() || ((Player)entity).isSneaking() || CityRoad.getInstance().getManageHandler().getTask().getSitMap().containsKey(entity.getUniqueId())) continue;
            armorStand.addPassenger(entity);
        }
    }

    public void stop() {
        this.isEnabled = false;
    }

    public void on() {
        this.isEnabled = true;
    }

    public boolean isExists(String paramString) {
        return CityRoad.getInstance().getManageHandler().getTask().getTaskSet().stream().anyMatch(x -> x.getDataManager().getUniqueString().equals(paramString));
    }

    public int getPlayerStage(UUID uuid) {
        SetUpManagerData setUpManagerData = CityRoad.getInstance().getManageHandler().getSetUpManagerData();
        Map<UUID, AbstractInfo> setMap = setUpManagerData.getAbstractInfoMap();
        if (!setMap.containsKey(uuid)) {
            return -1;
        }
        return setMap.get(uuid).getStage();
    }

    public void remove(String paramString) {
        ManageHandler manageHandler = CityRoad.getInstance().getManageHandler();
        HashSet<TickManager> taskSet = manageHandler.getTask().getTaskSet();
        TickManager tickManager = taskSet.stream().filter(x -> x.getDataManager().getUniqueString().equals(paramString)).findFirst().orElse(null);
        ArmorStand armorStand = tickManager.getTickArmorStand();
        if (armorStand != null) {
            armorStand.remove();
        }
        taskSet.remove(tickManager);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void restart(TickManager tickManager) {
        Location location = tickManager.getDataManager().getFirstLocation();
        tickManager.getTickArmorStand().remove();
        UUID armorStandUUID = this.spawnArmorStandUUID(location, tickManager.getDataManager().getHeadItem());
        tickManager.setTickArmorStand(armorStandUUID);
    }
}

