/*
 * Decompiled with CFR 0.152.
 */
package org.Gr_Code.CityRoad.Managers.Specific;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.Gr_Code.CityRoad.CityRoad;
import org.Gr_Code.CityRoad.Managers.ManageHandler;
import org.Gr_Code.CityRoad.RoadData.AbstractInfo;
import org.Gr_Code.CityRoad.RoadData.Type.TickManager;
import org.Gr_Code.CityRoad.Utils.Utils;
import org.bukkit.entity.ArmorStand;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Task {
    private Map<UUID, Integer> sitMap = new HashMap<UUID, Integer>();
    private HashSet<TickManager> taskSet = new HashSet();

    public Map<UUID, Integer> getSitMap() {
        return this.sitMap;
    }

    private void updateSit() {
        ManageHandler manageHandler = CityRoad.getInstance().getManageHandler();
        Map<UUID, Integer> sitMap = this.getSitMap();
        for (UUID uuid : sitMap.keySet()) {
            int paramInt = sitMap.get(uuid);
            if (paramInt == 0) {
                sitMap.remove(uuid);
            }
            sitMap.replace(uuid, paramInt - 1);
        }
    }

    public HashSet<TickManager> getTaskSet() {
        return this.taskSet;
    }

    public void tick() {
        new BukkitRunnable(){
            Utils utils = CityRoad.getInstance().getManageHandler().getUtils();

            public void run() {
                Task.this.updateSit();
                for (TickManager tickManager : Task.this.taskSet) {
                    ArmorStand armorStand = tickManager.getTickArmorStand();
                    if (armorStand == null) continue;
                    armorStand.setGravity(this.utils.isEnabled());
                    tickManager.setSit(this.utils.isEnabled());
                    AbstractInfo abstractInfo = tickManager.getDataManager();
                    Vector finalVector = tickManager.getFinalVector();
                    armorStand.setVelocity(finalVector.normalize().multiply(abstractInfo.getSpeed()));
                    if (tickManager.isSit()) {
                        this.utils.addPassenger(armorStand);
                    }
                    if (armorStand.getLocation().distance(abstractInfo.getSecondLocation()) < 1.0 && tickManager.isFirstLocation() && !tickManager.isSecondLocation()) {
                        tickManager.revertConditions();
                    }
                    if (!(armorStand.getLocation().distance(abstractInfo.getFirstLocation()) < 1.0) || tickManager.isFirstLocation() || !tickManager.isSecondLocation()) continue;
                    tickManager.revertConditions();
                }
            }
        }.runTaskTimer((Plugin)CityRoad.getInstance(), 0L, 1L);
    }
}

