/*
 * Decompiled with CFR 0.152.
 */
package org.Gr_Code.CityRoad.Managers.Specific;

import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;
import org.Gr_Code.CityRoad.CityRoad;
import org.Gr_Code.CityRoad.Managers.ManageHandler;
import org.Gr_Code.CityRoad.RoadData.AbstractInfo;
import org.Gr_Code.CityRoad.RoadData.RoadType;
import org.Gr_Code.CityRoad.RoadData.Type.TickManager;
import org.Gr_Code.CityRoad.Utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class DataSave {
    public void saveData() {
        FileConfiguration roads = CityRoad.getInstance().getRoadsConfiguration();
        ConfigurationSection roads_section = roads.getConfigurationSection("roads");
        HashSet<TickManager> set = CityRoad.getInstance().getManageHandler().getTask().getTaskSet();
        if (set.isEmpty()) {
            return;
        }
        for (TickManager tickManager : set) {
            AbstractInfo abstractInfo = tickManager.getDataManager();
            String name = abstractInfo.getUniqueString();
            roads.addDefault(name, (Object)"Speed");
            roads.set("roads." + name + ".Speed", (Object)abstractInfo.getSpeed());
            roads.set("roads." + name + ".Item", (Object)abstractInfo.getHeadItem().getType().toString());
            roads.set("roads." + name + ".World", (Object)abstractInfo.getFirstLocation().getWorld().getName());
            roads.set("roads." + name + ".X_1", (Object)abstractInfo.getFirstLocation().getX());
            roads.set("roads." + name + ".Y_1", (Object)abstractInfo.getFirstLocation().getY());
            roads.set("roads." + name + ".Z_1", (Object)abstractInfo.getFirstLocation().getZ());
            roads.set("roads." + name + ".X_2", (Object)abstractInfo.getSecondLocation().getX());
            roads.set("roads." + name + ".Y_2", (Object)abstractInfo.getSecondLocation().getY());
            roads.set("roads." + name + ".Z_2", (Object)abstractInfo.getSecondLocation().getZ());
        }
        try {
            roads.save(CityRoad.getInstance().getRoadsFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadData() {
        Utils utils = CityRoad.getInstance().getManageHandler().getUtils();
        FileConfiguration roads = CityRoad.getInstance().getRoadsConfiguration();
        ConfigurationSection roads_section = roads.getConfigurationSection("roads");
        ManageHandler manageHandler = CityRoad.getInstance().getManageHandler();
        if (roads_section == null) {
            return;
        }
        for (String string : roads_section.getKeys(false)) {
            double Speed = roads.getDouble("roads." + string + ".Speed");
            double X_1 = roads.getDouble("roads." + string + ".X_1");
            double Y_1 = roads.getDouble("roads." + string + ".Y_1");
            double Z_1 = roads.getDouble("roads." + string + ".Z_1");
            double X_2 = roads.getDouble("roads." + string + ".X_2");
            double Y_2 = roads.getDouble("roads." + string + ".Y_2");
            double Z_2 = roads.getDouble("roads." + string + ".Z_2");
            String world = roads.getString("roads." + string + ".World");
            Material material = Material.valueOf((String)roads.getString("roads." + string + ".Item"));
            Location location_1 = new Location(Bukkit.getWorld((String)world), X_1, Y_1, Z_1);
            Location location_2 = new Location(Bukkit.getWorld((String)world), X_2, Y_2, Z_2);
            ItemStack itemStack = new ItemStack(material);
            AbstractInfo abstractInfo = new AbstractInfo(RoadType.ROAD_DEFAULT);
            abstractInfo.setFirstLocation(location_1);
            abstractInfo.setSecondLocation(location_2);
            abstractInfo.setHeadItem(itemStack);
            abstractInfo.setUniqueString(string);
            abstractInfo.setSpeed(Speed);
            UUID uuid = utils.spawnArmorStandUUID(location_1, abstractInfo.getHeadItem());
            TickManager tickManager = new TickManager(abstractInfo, uuid);
            manageHandler.getTask().getTaskSet().add(tickManager);
        }
    }
}

