/*
 * Decompiled with CFR 0.152.
 */
package org.Gr_Code.CityRoad.Listeners;

import java.util.Map;
import java.util.UUID;
import org.Gr_Code.CityRoad.CityRoad;
import org.Gr_Code.CityRoad.Managers.ManageHandler;
import org.Gr_Code.CityRoad.Managers.Specific.ItemManager;
import org.Gr_Code.CityRoad.Managers.Specific.SetUpManagerData;
import org.Gr_Code.CityRoad.RoadData.AbstractInfo;
import org.Gr_Code.CityRoad.Utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

public class PlayerBlockPlaceEvent
implements Listener {
    @EventHandler
    public void onBlockPlace(BlockPlaceEvent paramEvent) {
        UUID uuid = paramEvent.getPlayer().getUniqueId();
        ManageHandler manageHandler = CityRoad.getInstance().getManageHandler();
        ItemManager itemManager = manageHandler.getItemManager();
        Utils utils = manageHandler.getUtils();
        SetUpManagerData setUpManagerData = manageHandler.getSetUpManagerData();
        Map<UUID, AbstractInfo> setMap = setUpManagerData.getAbstractInfoMap();
        Player player = paramEvent.getPlayer();
        Location location = paramEvent.getBlockPlaced().getLocation();
        int stage = utils.getPlayerStage(uuid);
        if (stage == -1) {
            return;
        }
        if (paramEvent.getItemInHand() == null) {
            return;
        }
        if (paramEvent.getItemInHand().isSimilar(itemManager.getFirstLocation()) && stage == 0) {
            AbstractInfo abstractInfo = setMap.get(uuid);
            player.sendMessage(ChatColor.DARK_GREEN + "1-st Location : " + ChatColor.GOLD + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            abstractInfo.setFirstLocation(location.add(0.5, 1.0, 0.5));
            player.getInventory().setItem(0, itemManager.getSecondLocation());
            paramEvent.setCancelled(true);
            setMap.get(uuid).setStage(1);
        } else if (paramEvent.getItemInHand().isSimilar(itemManager.getSecondLocation()) && stage == 1) {
            paramEvent.getPlayer().sendMessage(ChatColor.DARK_RED + "2nd Location : " + ChatColor.GOLD + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            AbstractInfo abstractInfo = setMap.get(uuid);
            abstractInfo.setSecondLocation(location.add(0.5, 1.0, 0.5));
            paramEvent.getPlayer().getInventory().setItem(0, null);
            paramEvent.setCancelled(true);
            paramEvent.getPlayer().sendMessage(utils.translate("&eEnter the name of Road in chat"));
            abstractInfo.setStage(2);
        }
    }

    @EventHandler
    public void onInteractPlayer(PlayerInteractAtEntityEvent e) {
        if (!(e.getRightClicked() instanceof ArmorStand)) {
            return;
        }
        Player player = e.getPlayer();
        ArmorStand armorStand = (ArmorStand)e.getRightClicked();
        if (armorStand.isVisible()) {
            return;
        }
        e.setCancelled(true);
    }
}

