/*
 * Decompiled with CFR 0.152.
 */
package org.Gr_Code.CityRoad.Commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.Gr_Code.CityRoad.CityRoad;
import org.Gr_Code.CityRoad.Commands.Acommand;
import org.Gr_Code.CityRoad.Managers.ManageHandler;
import org.Gr_Code.CityRoad.Managers.Specific.SetUpManagerData;
import org.Gr_Code.CityRoad.Managers.Specific.Task;
import org.Gr_Code.CityRoad.RoadData.AbstractInfo;
import org.Gr_Code.CityRoad.RoadData.RoadType;
import org.Gr_Code.CityRoad.Utils.Utils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CityCommand
extends Acommand {
    public CityCommand() {
        super("CityRoad");
    }

    @Override
    public void onCommand(CommandSender paramSender, String[] parramArrayString) {
        ManageHandler manageHandler = CityRoad.getInstance().getManageHandler();
        Utils utils = manageHandler.getUtils();
        SetUpManagerData setUpManagerData = manageHandler.getSetUpManagerData();
        Map<UUID, AbstractInfo> infoMap = setUpManagerData.getAbstractInfoMap();
        ItemStack first_location = manageHandler.getItemManager().getFirstLocation();
        if (paramSender instanceof Player && paramSender.hasPermission("cityroad.admin")) {
            Player player = (Player)paramSender;
            UUID uuid = player.getUniqueId();
            if (parramArrayString.length == 1) {
                if (parramArrayString[0].equalsIgnoreCase("create")) {
                    if (utils.getPlayerStage(uuid) != -1) {
                        player.sendMessage(utils.translate("&c&lYou need to finish the creating!"));
                        return;
                    }
                    if (player.getInventory().getItemInOffHand() != null && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
                        ItemStack itemStack = player.getInventory().getItemInOffHand();
                        utils.sendMessageSetUp(player);
                        AbstractInfo abstractInfo = new AbstractInfo(RoadType.ROAD_DEFAULT);
                        abstractInfo.setHeadItem(itemStack);
                        infoMap.put(uuid, abstractInfo);
                        player.getInventory().setItem(0, first_location);
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lYou must hold an Item in Off-Hand!"));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("list")) {
                    Task task = CityRoad.getInstance().getManageHandler().getTask();
                    if (task.getTaskSet().isEmpty()) {
                        player.sendMessage(utils.translate("&c&lThe list is Empty!"));
                        return;
                    }
                    ArrayList<String> paramString = new ArrayList<String>();
                    paramString.add(utils.translate("&e"));
                    task.getTaskSet().stream().forEach(x -> paramString.add(utils.translate(" &e") + x.getDataManager().getUniqueString()));
                    String string = ((Object)paramString).toString().substring(1);
                    player.sendMessage(string.replaceAll("]", "").substring(5));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("stop")) {
                    if (utils.getPlayerStage(uuid) != -1) {
                        player.sendMessage(utils.translate("&c&lStopped!"));
                        player.getInventory().setItem(0, null);
                        infoMap.remove(uuid);
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lYou are not in Creating-Session!"));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("list")) {
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("pause")) {
                    if (utils.isEnabled()) {
                        player.sendMessage(utils.translate("&b&lStopped!"));
                        utils.stop();
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lRoads are already stopped!"));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("continue")) {
                    if (!utils.isEnabled()) {
                        player.sendMessage(utils.translate("&e&lEnabled!"));
                        utils.on();
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lAlready enabled!"));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("remove") || parramArrayString[0].equalsIgnoreCase("restart") || parramArrayString[0].equalsIgnoreCase("upSpeed") || parramArrayString[0].equalsIgnoreCase("downSpeed")) {
                    player.sendMessage(utils.translate("&c&lYou need to Enter the name!"));
                    return;
                }
            }
            if (parramArrayString.length == 2) {
                if (parramArrayString[0].equalsIgnoreCase("remove")) {
                    String name = parramArrayString[1];
                    if (utils.isExists(name)) {
                        FileConfiguration configuration = CityRoad.getInstance().getRoadsConfiguration();
                        File file = CityRoad.getInstance().getRoadsFile();
                        utils.remove(name);
                        CityRoad.getInstance().getRoadsConfiguration().set("roads." + name, null);
                        try {
                            configuration.save(file);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        player.sendMessage(utils.translate("&6&lRemoved: &c&l" + name));
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lThis road does not exists!"));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("restart")) {
                    String name = parramArrayString[1];
                    if (utils.isExists(name)) {
                        utils.restart(utils.getTickManager(name));
                        player.sendMessage(utils.translate("&6&lRestarted: &c&l" + name));
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lThis road does not exists!"));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("upSpeed")) {
                    String name = parramArrayString[1];
                    if (utils.isExists(name)) {
                        double speed = utils.getTickManager(name).getDataManager().getSpeed();
                        if (speed <= 0.5) {
                            utils.getTickManager(name).getDataManager().setSpeed(speed + 0.05);
                            player.sendMessage(utils.translate("&6&lSpeed increased: &c&l" + name));
                            return;
                        }
                        player.sendMessage(utils.translate("&c&lSpeed is too high!"));
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lThis road does not exists!"));
                    return;
                }
                if (parramArrayString[0].equalsIgnoreCase("downSpeed")) {
                    String name = parramArrayString[1];
                    if (utils.isExists(name)) {
                        double speed = utils.getTickManager(name).getDataManager().getSpeed();
                        if (speed >= 0.1) {
                            utils.getTickManager(name).getDataManager().setSpeed(speed - 0.05);
                            player.sendMessage(utils.translate("&6&lSpeed decreased: &c&l" + name));
                            return;
                        }
                        player.sendMessage(utils.translate("&c&lSpeed is too small!"));
                        return;
                    }
                    player.sendMessage(utils.translate("&c&lThis road does not exists!"));
                    return;
                }
            }
        }
        paramSender.sendMessage(utils.translate("&c&lCouldn't find this command"));
    }
}

