/*
 * Decompiled with CFR 0.152.
 */
package org.Gr_Code.CityRoad;

import java.io.File;
import java.io.IOException;
import org.Gr_Code.CityRoad.Listeners.ConversationAnswers;
import org.Gr_Code.CityRoad.Listeners.PlayerBlockPlaceEvent;
import org.Gr_Code.CityRoad.Listeners.PlayerLeaveEvent;
import org.Gr_Code.CityRoad.Managers.ManageHandler;
import org.Gr_Code.CityRoad.Version.NMS;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CityRoad
extends JavaPlugin
implements Listener {
    private NMS nms;
    private File roadsFile;
    private FileConfiguration roadsConfiguration;
    private static CityRoad Instance;
    private ManageHandler manageHandler;

    private void setInstance(CityRoad instance) {
        Instance = instance;
    }

    public static CityRoad getInstance() {
        return Instance;
    }

    public ManageHandler getManageHandler() {
        return this.manageHandler;
    }

    public void onEnable() {
        this.createData();
        this.setInstance(this);
        this.manageHandler = new ManageHandler();
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerBlockPlaceEvent(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ConversationAnswers(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerLeaveEvent(), (Plugin)this);
        this.manageHandler.getManagerCMD().regCMDs();
        this.manageHandler.getTask().tick();
        this.manageHandler.getDataSave().loadData();
    }

    public void onDisable() {
        this.manageHandler.getTask().getTaskSet().stream().forEach(x -> x.getTickArmorStand().remove());
        this.manageHandler.getDataSave().saveData();
    }

    private void createData() {
        this.roadsFile = new File(this.getDataFolder(), "roads.yml");
        if (!this.roadsFile.exists()) {
            this.roadsFile.getParentFile().mkdirs();
            this.saveResource("roads.yml", false);
        }
        this.roadsConfiguration = new YamlConfiguration();
        try {
            this.roadsConfiguration.load(this.roadsFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getRoadsConfiguration() {
        return this.roadsConfiguration;
    }

    public File getRoadsFile() {
        return this.roadsFile;
    }

    public NMS getNms() {
        return this.nms;
    }
}

