/*
 * Decompiled with CFR 0.152.
 */
package tsp.noclip.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import tsp.noclip.Noclip;

public class NoClipManager {
    public static List<UUID> noClipPlayerNames;
    private final Noclip main;

    public NoClipManager(Noclip main) {
        noClipPlayerNames = new ArrayList<UUID>();
        this.main = main;
        this.everyTick();
    }

    private void everyTick() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.main, this::checkForBlocks, 0L, 1L);
    }

    private void checkForBlocks() {
        for (UUID uuid : noClipPlayerNames) {
            boolean noClip;
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (!p.isOnline()) continue;
            if (p.getGameMode().equals((Object)GameMode.CREATIVE)) {
                boolean bl = noClip = p.getLocation().add(0.0, -0.1, 0.0).getBlock().getType() != Material.AIR && p.isSneaking() || this.isNoClip(p);
                if (!noClip) continue;
                p.setGameMode(GameMode.SPECTATOR);
                continue;
            }
            if (!p.getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
            boolean bl = noClip = p.getLocation().add(0.0, -0.1, 0.0).getBlock().getType() != Material.AIR || this.isNoClip(p);
            if (noClip) continue;
            p.setGameMode(GameMode.CREATIVE);
        }
    }

    private boolean isNoClip(Player p) {
        boolean noClip = false;
        if (p.getLocation().add(0.4, 0.0, 0.0).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(-0.4, 0.0, 0.0).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(0.0, 0.0, 0.4).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(0.0, 0.0, -0.4).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(0.4, 1.0, 0.0).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(-0.4, 1.0, 0.0).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(0.0, 1.0, 0.4).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(0.0, 1.0, -0.4).getBlock().getType() != Material.AIR) {
            noClip = true;
        } else if (p.getLocation().add(0.0, 1.9, 0.0).getBlock().getType() != Material.AIR) {
            noClip = true;
        }
        return noClip;
    }
}

