/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.prisma;

import java.awt.Color;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import us.eunoians.prisma.Prisma;

public class ColorProvider {
    private static Map<Character, RGBWrapper> colorMap = new HashMap<Character, RGBWrapper>();
    private static Set<Character> vanillaCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('9'), Character.valueOf('8'), Character.valueOf('7'), Character.valueOf('6'), Character.valueOf('5'), Character.valueOf('4'), Character.valueOf('3'), Character.valueOf('2'), Character.valueOf('1'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('r'), Character.valueOf('&'), Character.valueOf('\u00a7')));

    protected static void init(Prisma prisma) {
        File file = new File(prisma.getDataFolder(), "colors.yml");
        YamlConfiguration fileConfiguration = YamlConfiguration.loadConfiguration((File)file);
        for (String color : fileConfiguration.getConfigurationSection("ChatColors").getKeys(false)) {
            String key = "ChatColors." + color + ".";
            char chatChar = fileConfiguration.getString(key + "ColorCode").charAt(0);
            RGBWrapper rgbWrapper = null;
            if (fileConfiguration.contains(key + "RGB")) {
                String[] RGB = fileConfiguration.getString(key + "RGB").split(":");
                int red = Integer.parseInt(RGB[0]);
                int green = Integer.parseInt(RGB[1]);
                int blue = Integer.parseInt(RGB[2]);
                rgbWrapper = new RGBWrapper(red, green, blue);
            } else if (fileConfiguration.contains(key + "Hex")) {
                rgbWrapper = new RGBWrapper(fileConfiguration.getString(key + "Hex"));
            }
            colorMap.put(Character.valueOf(chatChar), rgbWrapper);
        }
    }

    public static String translatePrisma(String message) {
        return ColorProvider.translatePrisma(message, true);
    }

    public static String translatePrismaToHex(String message) {
        return ColorProvider.translatePrismaToHex(message, true);
    }

    public static String translatePrismaToHex(String message, boolean prepend) {
        StringBuilder builder = new StringBuilder();
        boolean isColor = false;
        for (char letter : message.toCharArray()) {
            if (letter == '&' || letter == '\u00a7') {
                isColor = true;
                continue;
            }
            if (isColor) {
                isColor = false;
                if (colorMap.containsKey(Character.valueOf(letter))) {
                    builder.append(colorMap.get(Character.valueOf(letter)).toHex(prepend));
                    continue;
                }
            }
            builder.append(letter);
        }
        return builder.toString();
    }

    public static String translatePrisma(String message, boolean returnWithVanillaColor) {
        StringBuilder builder = new StringBuilder();
        boolean isColor = false;
        char colorCode = '&';
        for (char letter : message.toCharArray()) {
            if (isColor) {
                isColor = false;
                if (vanillaCharacters.contains(Character.valueOf(letter))) {
                    builder.append(colorCode);
                    builder.append(letter);
                    continue;
                }
                if (colorMap.containsKey(Character.valueOf(letter))) {
                    builder.append(ChatColor.of((String)colorMap.get(Character.valueOf(letter)).toHex()));
                    continue;
                }
                builder.append(colorCode);
                builder.append(letter);
                continue;
            }
            if (letter == '&' || letter == '\u00a7') {
                isColor = true;
                colorCode = letter;
                continue;
            }
            builder.append(letter);
        }
        return returnWithVanillaColor ? ChatColor.translateAlternateColorCodes((char)'&', (String)builder.toString()) : builder.toString();
    }

    public static RGBWrapper getRGBWrapper(char chatCode) {
        return colorMap.get(Character.valueOf(chatCode));
    }

    protected static class RGBWrapper {
        private static final Pattern HEX_PATTERN = Pattern.compile("#?([a-f\\d]{2})([a-f\\d]{2})([a-f\\d]{2})$");
        private int red;
        private int green;
        private int blue;

        public RGBWrapper(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public RGBWrapper(String hex) {
            Color color = Color.decode(hex);
            this.red = color.getRed();
            this.green = color.getGreen();
            this.blue = color.getBlue();
        }

        public String toHex() {
            return this.toHex(true);
        }

        public String toHex(boolean prepend) {
            StringBuilder builder = new StringBuilder();
            if (prepend) {
                builder.append("#");
            }
            builder.append(String.format("%02x%02x%02x", this.red, this.green, this.blue));
            return builder.toString();
        }

        public Color toColor() {
            return new Color(this.red, this.green, this.blue);
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        public void setRed(int red) {
            this.red = red;
        }

        public void setGreen(int green) {
            this.green = green;
        }

        public void setBlue(int blue) {
            this.blue = blue;
        }
    }
}

