/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.scoreboard;

import de.pierreschwang.spigotlib.scoreboard.AbstractScoreboard;
import de.pierreschwang.spigotlib.user.User;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class InternalScoreboard<T extends User> {
    private final Scoreboard scoreboard;
    private final Objective objective;
    private final AbstractScoreboard handler;
    private final T user;
    private int sidebarTeamCounter = 0;
    private final Map<Integer, String> currentSidebar = new HashMap<Integer, String>();

    public InternalScoreboard(AbstractScoreboard handler, T user) {
        this.handler = handler;
        this.user = user;
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.objective = this.scoreboard.registerNewObjective(((User)user).getPlayer().getName(), "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        ((User)user).getPlayer().setScoreboard(this.scoreboard);
        this.refreshSidebar();
    }

    public void refresh() {
        this.refresh(Bukkit.getOnlinePlayers().toArray(new Player[0]));
    }

    public void refresh(Player ... players) {
        for (Player player : players) {
            if (Bukkit.getPlayer((UUID)player.getUniqueId()) == null && this.scoreboard.getTeam(player.getName()) != null) {
                this.scoreboard.getTeam(player.getName()).unregister();
            }
            Object pUser = this.handler.getPlugin().getUser(player);
            Team team = this.getOrCreate(player.getName(), this.handler.getPlugin().getPlayerRenderer().getPrefix().apply((User)pUser), this.handler.getPlugin().getPlayerRenderer().getSuffix().apply((User)pUser));
            if (team.hasEntry(player.getName())) continue;
            team.addEntry(player.getName());
        }
        String title = this.handler.getPlugin().getPlayerRenderer().getSidebarTitle().apply((User)this.user);
        if (title != null) {
            this.objective.setDisplayName(title);
        }
    }

    public void refreshSidebar() {
        this.scoreboard.getEntries().forEach(arg_0 -> ((Scoreboard)this.scoreboard).resetScores(arg_0));
        String[] lines = this.handler.getPlugin().getPlayerRenderer().getLines().apply((User)this.user);
        int score = lines.length;
        for (String s : lines) {
            this.rerenderScore(score, s);
            --score;
        }
    }

    public Team getOrCreate(String name, String prefix, String suffix) {
        Team team = this.scoreboard.getTeam(name);
        if (team == null) {
            team = this.scoreboard.registerNewTeam(name);
        }
        if (prefix != null) {
            team.setPrefix(prefix);
        }
        if (suffix != null) {
            team.setSuffix(suffix);
        }
        return team;
    }

    private InternalScoreboard<T> setScore(int score, String value) {
        this.objective.getScore(value).setScore(score);
        this.currentSidebar.put(score, value);
        return this;
    }

    public InternalScoreboard<T> removeScore(int score) {
        String entry = this.currentSidebar.get(score);
        if (entry != null) {
            this.scoreboard.resetScores(entry);
            if (this.scoreboard.getTeam(entry) != null) {
                this.scoreboard.getTeam(entry).unregister();
            }
        }
        return this;
    }

    private void rerenderScore(int score, String line) {
        Team team = this.createSidebarTeam(line);
        this.setScore(score, team.getDisplayName());
    }

    private Team createSidebarTeam(String label) {
        Team team = this.scoreboard.registerNewTeam("Sidebar-" + this.sidebarTeamCounter++);
        if (label.length() < 17) {
            team.setDisplayName(label);
        } else if (label.length() < 33) {
            team.setPrefix(label.substring(0, 16));
            team.setDisplayName(label.substring(16));
        } else if (label.length() < 49) {
            team.setPrefix(label.substring(0, 16));
            team.setDisplayName(label.substring(16, 32));
            team.setSuffix(label.substring(32));
        } else {
            throw new IllegalArgumentException("The line must be shorter than 49 chars!");
        }
        team.addEntry(team.getDisplayName());
        return team;
    }

    Objective getObjective() {
        return this.objective;
    }
}

