/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.nms.intercept;

import de.pierreschwang.spigotlib.nms.intercept.PacketInterceptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PacketInterceptorRegistry {
    private static final Set<PacketInterceptor> EMPTY_SET = new HashSet<PacketInterceptor>();
    private final Map<String, Set<PacketInterceptor>> interceptors = new HashMap<String, Set<PacketInterceptor>>();

    public void registerInterceptor(String packetName, PacketInterceptor handler) {
        this.interceptors.computeIfAbsent(packetName, s -> new HashSet()).add(handler);
    }

    public Set<PacketInterceptor> getInterceptors(String packet) {
        return this.interceptors.getOrDefault(packet, EMPTY_SET);
    }

    public Map<String, Set<PacketInterceptor>> getInterceptors() {
        return this.interceptors;
    }
}

