/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.lang;

import de.pierreschwang.spigotlib.AbstractJavaPlugin;
import de.pierreschwang.spigotlib.lang.Language;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bukkit.ChatColor;

public class LanguageHandler {
    private final Map<String, Language> languages = new HashMap<String, Language>();
    private final AbstractJavaPlugin<?> plugin;

    public LanguageHandler(AbstractJavaPlugin<?> plugin) {
        this.plugin = plugin;
        File languageFolder = new File(plugin.getDataFolder() + "/lang");
        languageFolder.mkdirs();
        this.copyFromResources(languageFolder.toPath());
        this.loadLanguages(languageFolder);
    }

    private void loadLanguages(File languageFolder) {
        File[] files = languageFolder.listFiles((dir, name) -> name.endsWith(".properties"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                Properties properties = new Properties();
                properties.load(reader);
                HashMap<String, String> translations = new HashMap<String, String>();
                for (String key : properties.stringPropertyNames()) {
                    translations.put(key, ChatColor.translateAlternateColorCodes((char)'&', (String)properties.getProperty(key)));
                }
                String fileName = file.getName().substring(0, file.getName().lastIndexOf(46));
                this.languages.put(fileName, new Language(fileName, translations));
                this.plugin.getLogger().info("[+] Loaded language " + fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyFromResources(final Path target) {
        try {
            final Path path = this.getLanguageTemplateDir();
            if (path == null) {
                throw new NullPointerException("Language template directory could not be found");
            }
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.toString().endsWith(".properties")) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path dest = target.resolve(path.relativize(file).toString());
                    if (!dest.toFile().exists()) {
                        Files.copy(file, dest, new CopyOption[0]);
                    }
                    try (BufferedReader reader = Files.newBufferedReader(file);){
                        LanguageHandler.this.synchronize(reader, dest);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Path getLanguageTemplateDir() {
        try {
            FileSystem fileSystem;
            URI uri = this.getClass().getResource("").toURI();
            try {
                fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
            return fileSystem.getPath("/lang", new String[0]);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void synchronize(BufferedReader template, Path current) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(current.toFile(), true));
             BufferedReader reader = new BufferedReader(new FileReader(current.toFile()));){
            Properties properties = new Properties();
            properties.load(template);
            Properties curr = new Properties();
            curr.load(reader);
            for (String key : properties.stringPropertyNames()) {
                if (curr.containsKey(key)) continue;
                writer.newLine();
                writer.write(key + " = " + properties.getProperty(key));
                writer.newLine();
                curr.setProperty(key, properties.getProperty(key));
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String translate(String language, String key, Object ... params) {
        return this.languages.getOrDefault(language, this.languages.get("en_US")).translate(key, params);
    }
}

