/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.inventory;

import de.pierreschwang.spigotlib.inventory.SimpleInventory;
import de.pierreschwang.spigotlib.inventory.exceptions.PageIndexOutOfBoundsException;
import de.pierreschwang.spigotlib.item.ItemFactory;
import java.util.LinkedHashMap;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SimplePaginatedInventory
extends SimpleInventory {
    private final LinkedHashMap<Integer, ItemStack> inventoryContents = new LinkedHashMap();
    private int currentPage = 1;

    SimplePaginatedInventory(int size, String title) {
        super(size, title);
    }

    SimplePaginatedInventory(int size) {
        this(size, "Inventory");
    }

    public LinkedHashMap<Integer, ItemStack> getInventoryContents() {
        return this.inventoryContents;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getMaxPage() {
        int highestItemSlot = this.getMaxItemIndex();
        return (int)Math.ceil((float)(highestItemSlot + 1) / (float)this.getInventory().getSize());
    }

    public int getMaxItemIndex() {
        OptionalInt optionalHighestItemSlot = this.getInventoryContents().keySet().stream().mapToInt(Integer::intValue).max();
        if (!optionalHighestItemSlot.isPresent()) {
            return -1;
        }
        return optionalHighestItemSlot.getAsInt();
    }

    public int getOffsetForPage(int page) {
        return (page - 1) * this.getInventory().getSize();
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public SimplePaginatedInventory setItem(int page, int slot, ItemStack item, Consumer<InventoryClickEvent> eventConsumer) {
        if (page < 1) {
            throw new PageIndexOutOfBoundsException("Page number can not be less than 1");
        }
        int targetSlot = slot + this.getOffsetForPage(page);
        this.inventoryContents.put(targetSlot, item);
        super.getClickHandlers().put(targetSlot, eventConsumer);
        return this;
    }

    @Override
    public SimplePaginatedInventory setItem(int slot, ItemStack item, Consumer<InventoryClickEvent> eventConsumer) {
        return this.setItem(1, slot, item, eventConsumer);
    }

    @Override
    public SimplePaginatedInventory setItem(int slot, ItemFactory<?> item, Consumer<InventoryClickEvent> eventConsumer) {
        return this.setItem(slot, item.apply(), (Consumer)eventConsumer);
    }

    @Override
    public SimplePaginatedInventory setItem(int slot, ItemStack item) {
        return this.setItem(slot, item, event -> {});
    }

    @Override
    public SimplePaginatedInventory setItem(int slot, ItemFactory<?> item) {
        return this.setItem(slot, item.apply(), event -> {});
    }

    public SimplePaginatedInventory addItem(ItemStack item, Consumer<InventoryClickEvent> eventConsumer) {
        int maxSlot = this.getMaxItemIndex();
        for (int index = 0; index < maxSlot; ++index) {
            if (this.getInventoryContents().get(index) != null) continue;
            return this.setItem(index, item, (Consumer)eventConsumer);
        }
        return this.setItem(maxSlot + 1, item, (Consumer)eventConsumer);
    }

    public SimplePaginatedInventory addItem(ItemFactory<?> item, Consumer<InventoryClickEvent> eventConsumer) {
        return this.addItem(item.apply(), eventConsumer);
    }

    public SimplePaginatedInventory addItem(ItemStack item) {
        return this.addItem(item, (InventoryClickEvent event) -> {});
    }

    public SimplePaginatedInventory addItem(ItemFactory<?> item) {
        return this.addItem(item.apply(), (InventoryClickEvent event) -> {});
    }

    public void open(int page, Player ... players) {
        int offset;
        if (page < 0) {
            throw new PageIndexOutOfBoundsException("Page number can not be less than 1");
        }
        this.setCurrentPage(page);
        for (int index = offset = this.getOffsetForPage(page); index < offset + this.getInventory().getSize(); ++index) {
            this.getInventory().setItem(index - offset, this.getInventoryContents().get(index));
        }
        for (Player player : players) {
            player.openInventory(this.getInventory());
        }
    }

    @Override
    public void open(Player ... players) {
        this.open(1, players);
    }
}

