/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.inventory;

import de.pierreschwang.spigotlib.item.ItemFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SimpleInventory {
    private final Inventory inventory;
    private final Map<Integer, Consumer<InventoryClickEvent>> clickHandlers = new HashMap<Integer, Consumer<InventoryClickEvent>>();
    private Consumer<Player> inventoryCloseListener;

    SimpleInventory(int size, String title) {
        this.inventoryCloseListener = player -> {};
        this.inventory = Bukkit.createInventory(null, (int)size, (String)title);
    }

    SimpleInventory(int size) {
        this.inventoryCloseListener = player -> {};
        this.inventory = Bukkit.createInventory(null, (int)size);
    }

    SimpleInventory(InventoryType type) {
        this.inventoryCloseListener = player -> {};
        this.inventory = Bukkit.createInventory(null, (InventoryType)type);
    }

    SimpleInventory(InventoryType type, String title) {
        this.inventoryCloseListener = player -> {};
        this.inventory = Bukkit.createInventory(null, (InventoryType)type, (String)title);
    }

    public SimpleInventory setItem(int slot, ItemStack item, Consumer<InventoryClickEvent> eventConsumer) {
        this.inventory.setItem(slot, item);
        this.clickHandlers.put(slot, eventConsumer);
        return this;
    }

    public SimpleInventory setItem(int slot, ItemFactory<?> item, Consumer<InventoryClickEvent> eventConsumer) {
        return this.setItem(slot, item.apply(), eventConsumer);
    }

    public SimpleInventory setItem(int slot, ItemStack item) {
        return this.setItem(slot, item, (InventoryClickEvent ev) -> {});
    }

    public SimpleInventory setItem(int slot, ItemFactory<?> item) {
        return this.setItem(slot, item, (InventoryClickEvent ev) -> {});
    }

    public SimpleInventory fill(int beginning, int end, ItemStack item) {
        for (int i = beginning; i < end; ++i) {
            this.setItem(i, item);
        }
        return this;
    }

    public SimpleInventory fill(int beginning, int end, ItemFactory<?> item) {
        return this.fill(beginning, end, item.apply());
    }

    public SimpleInventory setCloseListener(Consumer<Player> eventConsumer) {
        this.inventoryCloseListener = eventConsumer;
        return this;
    }

    public void open(Player ... players) {
        for (Player player : players) {
            player.openInventory(this.inventory);
        }
    }

    Inventory getInventory() {
        return this.inventory;
    }

    Map<Integer, Consumer<InventoryClickEvent>> getClickHandlers() {
        return this.clickHandlers;
    }

    Consumer<Player> getInventoryCloseListener() {
        return this.inventoryCloseListener;
    }
}

