/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.internal.interceptors;

import de.pierreschwang.spigotlib.AbstractJavaPlugin;
import de.pierreschwang.spigotlib.event.PlayerLocaleUpdateEvent;
import de.pierreschwang.spigotlib.event.PlayerReadyEvent;
import de.pierreschwang.spigotlib.nms.NmsHelper;
import de.pierreschwang.spigotlib.nms.intercept.PacketInterceptor;
import de.pierreschwang.spigotlib.user.User;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PacketPlayInSettingsInterceptor
implements PacketInterceptor {
    private final AbstractJavaPlugin<?> plugin;
    private Field languageField;

    public PacketPlayInSettingsInterceptor(AbstractJavaPlugin<?> plugin) {
        this.plugin = plugin;
        Class<?> packetPlayInSettings = NmsHelper.getNmsClass("PacketPlayInSettings");
        for (Field field : packetPlayInSettings.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(String.class)) continue;
            this.languageField = field;
            this.languageField.setAccessible(true);
            break;
        }
    }

    @Override
    public void onPacketReceive(Player player, Object packet, ChannelHandlerContext ctx) {
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            try {
                String locale = (String)this.languageField.get(packet);
                Object user = this.plugin.getUser(player);
                if (((User)user).getLocale() == null) {
                    ((User)user).setLocale(locale);
                    Bukkit.getPluginManager().callEvent(new PlayerReadyEvent(user, player));
                    return;
                }
                if (!locale.equals(((User)user).getLocale())) {
                    Bukkit.getPluginManager().callEvent((Event)new PlayerLocaleUpdateEvent(player, ((User)user).getLocale(), locale));
                }
                ((User)user).setLocale(locale);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

