/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.internal;

import de.pierreschwang.spigotlib.AbstractJavaPlugin;
import de.pierreschwang.spigotlib.nms.NmsHelper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import org.bukkit.entity.Player;

public class PlayerPacketInterceptor {
    private final AbstractJavaPlugin<?> plugin;
    private Field channelField;

    public PlayerPacketInterceptor(AbstractJavaPlugin<?> plugin) {
        this.plugin = plugin;
        Class<?> networkManager = NmsHelper.getNmsClass("NetworkManager");
        for (Field field : networkManager.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(Channel.class)) continue;
            this.channelField = field;
            this.channelField.setAccessible(true);
            break;
        }
    }

    public void register(final Player player) {
        Channel channel = this.getNetworkChannel(player);
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addAfter("decoder", "packetInterceptorListener", (ChannelHandler)new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext channelHandlerContext, Object packet) throws Exception {
                String packetName = packet.getClass().getSimpleName();
                PlayerPacketInterceptor.this.plugin.getPacketInterceptorRegistry().getInterceptors(packetName).forEach(interceptor -> interceptor.onPacketReceive(player, packet, channelHandlerContext));
                super.channelRead(channelHandlerContext, packet);
            }
        });
    }

    public void unregister(Player player) {
        Channel channel = this.getNetworkChannel(player);
        if (channel == null || channel.pipeline() == null) {
            return;
        }
        if (channel.pipeline().get("packetInterceptorListener") != null) {
            channel.pipeline().remove("packetInterceptorListener");
        }
    }

    private Channel getNetworkChannel(Player player) {
        Object networkManager = this.getNetworkManager(player);
        try {
            return (Channel)this.channelField.get(networkManager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getNetworkManager(Player player) {
        try {
            Object playerHandle = NmsHelper.playerHandle(player);
            Object playerConnection = playerHandle.getClass().getField("playerConnection").get(playerHandle);
            return playerConnection.getClass().getField("networkManager").get(playerConnection);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }
}

