/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.internal;

import de.pierreschwang.spigotlib.AbstractJavaPlugin;
import de.pierreschwang.spigotlib.event.PlayerReadyEvent;
import de.pierreschwang.spigotlib.internal.PlayerPacketInterceptor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final AbstractJavaPlugin<?> plugin;
    private final PlayerPacketInterceptor playerPacketInterceptor;

    public PlayerListener(AbstractJavaPlugin<?> plugin) {
        this.plugin = plugin;
        this.playerPacketInterceptor = new PlayerPacketInterceptor(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            this.plugin.getUserRepository().create(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.playerPacketInterceptor.register(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerReady(PlayerReadyEvent<?> event) {
        this.plugin.getScoreboard().show(event.getUser()).refresh();
        this.plugin.getScoreboard().refresh(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.playerPacketInterceptor.unregister(event.getPlayer());
        this.plugin.getScoreboard().hide(this.plugin.getUserRepository().getUser(event.getPlayer()));
        this.plugin.getUserRepository().getUsers().remove(event.getPlayer());
        this.plugin.getScoreboard().refresh(event.getPlayer());
    }
}

