/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.hologram;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

public class Hologram {
    private static final double MARGIN = 0.28;
    private final Location location;
    private final List<ArmorStand> lines;

    public Hologram(Location location, String ... lines) {
        this.location = location.add(0.0, 0.28 * (double)lines.length, 0.0);
        this.lines = new ArrayList<ArmorStand>();
        this.addLines(lines);
    }

    public void destroy() {
        this.lines.forEach(Entity::remove);
    }

    public void setLine(int line, String content) {
        if (this.lines.get(line) == null) {
            return;
        }
        this.lines.get(line).setCustomName(content);
    }

    public void addLines(String ... lines) {
        this.lines.forEach(stand -> stand.teleport(this.location.add(0.0, 0.28 * (double)lines.length, 0.0)));
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            this.lines.add(this.spawnLine(this.location.clone().add(0.0, -((double)i * 0.28), 0.0), line));
        }
    }

    private ArmorStand spawnLine(Location location, String line) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        armorStand.setCustomName(line);
        armorStand.setCustomNameVisible(true);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        return armorStand;
    }
}

