/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.hologram;

import de.pierreschwang.spigotlib.nms.NmsArmorStand;
import de.pierreschwang.spigotlib.nms.NmsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class DynamicHologram {
    private static final double MARGIN = 0.28;
    private final Location location;
    private Function<Player, String[]> lines;
    private Map<Player, List<NmsArmorStand>> armorStands;

    public DynamicHologram(Location location, Function<Player, String[]> lines) {
        this.location = location;
        this.lines = lines;
        this.armorStands = new HashMap<Player, List<NmsArmorStand>>();
    }

    public void destroy() {
        this.armorStands.keySet().forEach(this::destroy);
    }

    public void destroy(Player player) {
        if (!this.armorStands.containsKey(player)) {
            return;
        }
        this.armorStands.get(player).forEach(NmsArmorStand::remove);
        this.armorStands.remove(player);
    }

    public void spawn(Player player) {
        String[] lines = this.lines.apply(player);
        Location location = this.location.clone();
        this.armorStands.put(player, new ArrayList());
        for (String line : lines) {
            this.armorStands.get(player).add(NmsHelper.getCraftEntity().spawnHologramLine(player, location.add(0.0, -0.28, 0.0), line));
        }
    }

    public void spawn() {
        Bukkit.getOnlinePlayers().forEach(this::spawn);
    }

    public void respawn(Player player) {
        this.destroy(player);
        this.spawn(player);
    }

    public void respawn() {
        this.destroy();
        this.spawn();
    }
}

