/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib.command;

import de.pierreschwang.spigotlib.AbstractJavaPlugin;
import de.pierreschwang.spigotlib.command.Command;
import de.pierreschwang.spigotlib.command.CommandData;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.SimplePluginManager;

public class CommandRegistry {
    private final AbstractJavaPlugin<?> plugin;
    private CommandMap commandMap;

    public CommandRegistry(AbstractJavaPlugin<?> plugin) {
        this.plugin = plugin;
        this.loadMap();
    }

    private void loadMap() {
        if (!(this.plugin.getServer().getPluginManager() instanceof SimplePluginManager)) {
            throw new IllegalStateException("Plugin Manager is not an instance of SimplePluginManager!");
        }
        SimplePluginManager pluginManager = (SimplePluginManager)this.plugin.getServer().getPluginManager();
        try {
            Field field = pluginManager.getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            this.commandMap = (CommandMap)field.get(pluginManager);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void registerCommand(final Command command) {
        if (!command.getClass().isAnnotationPresent(CommandData.class)) {
            throw new IllegalArgumentException("Command " + command.getClass().getSimpleName() + " is missing the @CommandData annotation");
        }
        final CommandData data = command.getClass().getAnnotation(CommandData.class);
        this.commandMap.register(data.name(), this.plugin.getName(), new org.bukkit.command.Command(data.name(), data.description(), data.usage(), Arrays.asList(data.aliases())){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                if (!data.permission().isEmpty() && !sender.hasPermission(data.permission())) {
                    sender.sendMessage("\u00a7cYou dont have permission to do that!");
                    return true;
                }
                return command.onCommand(sender, this, commandLabel, args);
            }
        });
    }
}

