/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.spigotlib;

import de.pierreschwang.spigotlib.command.CommandRegistry;
import de.pierreschwang.spigotlib.database.ConnectionProvider;
import de.pierreschwang.spigotlib.database.StandardConnectionProvider;
import de.pierreschwang.spigotlib.internal.PlayerListener;
import de.pierreschwang.spigotlib.internal.interceptors.PacketPlayInSettingsInterceptor;
import de.pierreschwang.spigotlib.inventory.InventoryListener;
import de.pierreschwang.spigotlib.lang.LanguageHandler;
import de.pierreschwang.spigotlib.nms.intercept.PacketInterceptorRegistry;
import de.pierreschwang.spigotlib.scoreboard.AbstractScoreboard;
import de.pierreschwang.spigotlib.scoreboard.PlayerRenderer;
import de.pierreschwang.spigotlib.user.User;
import de.pierreschwang.spigotlib.user.UserFactory;
import de.pierreschwang.spigotlib.user.UserRepository;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractJavaPlugin<T extends User>
extends JavaPlugin {
    private LanguageHandler languageHandler;
    private CommandRegistry commandRegistry;
    private UserRepository<T> userRepository;
    private AbstractScoreboard scoreboard;
    private PacketInterceptorRegistry packetInterceptorRegistry;

    public void onEnable() {
        this.commandRegistry = new CommandRegistry(this);
        this.languageHandler = new LanguageHandler(this);
        this.userRepository = new UserRepository(this);
        this.scoreboard = new AbstractScoreboard(this);
        this.packetInterceptorRegistry = new PacketInterceptorRegistry();
        this.packetInterceptorRegistry.registerInterceptor("PacketPlayInSettings", new PacketPlayInSettingsInterceptor(this));
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.onAbstractEnable();
    }

    public void onDisable() {
        this.onAbstractDisable();
    }

    public abstract void onAbstractEnable();

    public abstract void onAbstractDisable();

    public UserRepository<T> getUserRepository() {
        return this.userRepository;
    }

    public LanguageHandler getLanguageHandler() {
        return this.languageHandler;
    }

    public abstract UserFactory<T> getUserFactory();

    public PlayerRenderer getPlayerRenderer() {
        return new PlayerRenderer(){

            @Override
            public Function<User, String> getPrefix() {
                return p -> "";
            }

            @Override
            public Function<User, String> getSuffix() {
                return p -> "";
            }

            @Override
            public Function<User, String> getSidebarTitle() {
                return p -> "";
            }

            @Override
            public Function<User, String[]> getLines() {
                return p -> new String[0];
            }
        };
    }

    public Class<? extends ConnectionProvider> getConnectionProvider() {
        return StandardConnectionProvider.class;
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public T getUser(Player player) {
        return this.userRepository.getUser(player);
    }

    public AbstractScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public PacketInterceptorRegistry getPacketInterceptorRegistry() {
        return this.packetInterceptorRegistry;
    }
}

