/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.pinlogin.user;

import de.pierreschwang.pinlogin.PinloginPlugin;
import de.pierreschwang.pinlogin.event.InitialPinSetEvent;
import de.pierreschwang.pinlogin.event.PinChangedEvent;
import de.pierreschwang.spigotlib.user.User;
import java.util.concurrent.CompletableFuture;
import net.cubespace.Yamler.Config.InvalidConfigurationException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;

public class PinUser
extends User {
    private final PinloginPlugin plugin;
    private int pin = -1;
    private boolean authorized = false;

    public PinUser(PinloginPlugin plugin, Player player) {
        super(plugin, player);
        this.plugin = plugin;
        this.getPin();
    }

    public void setPin(int pin) {
        this.pin = pin;
        String uuid = this.getPlayer().getUniqueId().toString();
        this.plugin.executeAsync(() -> {
            if (this.plugin.getPinConfig().getPinStorage().containsKey(uuid)) {
                this.callSyncEvent((Event)new PinChangedEvent(this, this.getPlayer(), this.pin));
            } else {
                this.callSyncEvent((Event)new InitialPinSetEvent(this, this.getPlayer(), this.pin));
            }
            this.plugin.getPinConfig().getPinStorage().put(uuid, this.pin);
            try {
                this.plugin.getPinConfig().save();
                this.plugin.getPinConfig().reload();
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
        });
    }

    public CompletableFuture<Integer> getPin() {
        if (this.pin > 0) {
            return CompletableFuture.completedFuture(this.pin);
        }
        return CompletableFuture.supplyAsync(() -> {
            this.pin = this.plugin.getPinConfig().getPinStorage().getOrDefault(this.getPlayer().getUniqueId().toString(), -1);
            return this.pin;
        });
    }

    public void callSyncEvent(final Event event) {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getPluginManager().callEvent(event);
            }
        }.runTask(this.getPlugin());
    }

    public void setAuthorized(boolean authorized) {
        this.authorized = authorized;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }
}

