/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.pinlogin.inventory;

import de.pierreschwang.pinlogin.inventory.InventoryConstants;
import de.pierreschwang.pinlogin.user.PinUser;
import de.pierreschwang.spigotlib.inventory.InventoryFactory;
import de.pierreschwang.spigotlib.inventory.SimpleInventory;
import de.pierreschwang.spigotlib.item.ItemFactory;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class SetPinInventory {
    private final PinUser user;
    private final SimpleInventory inventory;
    private final boolean isAllowedToClose;
    private final StringBuilder enteredPin = new StringBuilder();

    public SetPinInventory(PinUser user, boolean isAllowedToClose) {
        this.user = user;
        this.inventory = InventoryFactory.create(InventoryType.DISPENSER, user.getMessage("inventory-pin-title", new Object[0]));
        this.isAllowedToClose = isAllowedToClose;
    }

    public void onNumberClick(int number) {
        this.enteredPin.append(number);
        if (this.enteredPin.length() < 4) {
            return;
        }
        InventoryConstants.TEXTURE_NUMBERS.forEach((i, texture) -> {
            ItemStack skull = ItemFactory.skull().texture((String)texture).name(this.user.getMessage("inventory-authorization-number", i)).apply();
            this.inventory.setItem(i - 1, skull, event -> {});
        });
        if (!this.isAllowedToClose) {
            this.user.getPlayer().setWalkSpeed(0.2f);
            this.user.getPlayer().removePotionEffect(PotionEffectType.BLINDNESS);
        }
        this.user.setAuthorized(true);
        this.user.setPin(Integer.parseInt(this.enteredPin.toString()));
        this.user.getPlayer().playSound(this.user.getPlayer().getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
        this.inventory.setCloseListener(player -> {});
        this.user.getPlayer().closeInventory();
    }

    private void reset() {
        this.enteredPin.setLength(0);
        InventoryConstants.TEXTURE_NUMBERS.forEach((number, texture) -> {
            ItemStack skull = ItemFactory.skull().texture((String)texture).name(this.user.getMessage("inventory-authorization-number", number)).apply();
            this.inventory.setItem(number - 1, skull, event -> this.onNumberClick((int)number));
        });
    }

    public void open() {
        if (!this.isAllowedToClose) {
            this.inventory.setCloseListener(player -> {
                this.user.sendMessage("inventory-pin-set-initial-close", new Object[0]);
                player.playSound(player.getLocation(), Sound.ANVIL_BREAK, 1.0f, 1.0f);
                Bukkit.getScheduler().runTaskLaterAsynchronously(this.user.getPlugin(), () -> new SetPinInventory(this.user, false).open(), 1L);
            });
        }
        this.reset();
        this.inventory.open(this.user.getPlayer());
    }
}

