/*
 * Decompiled with CFR 0.152.
 */
package de.pierreschwang.pinlogin.inventory;

import de.pierreschwang.pinlogin.PinloginPlugin;
import de.pierreschwang.pinlogin.event.PinAuthorizationFailedEvent;
import de.pierreschwang.pinlogin.event.PinAuthorizationSuccessEvent;
import de.pierreschwang.pinlogin.inventory.InventoryConstants;
import de.pierreschwang.pinlogin.user.PinUser;
import de.pierreschwang.spigotlib.inventory.InventoryFactory;
import de.pierreschwang.spigotlib.inventory.SimpleInventory;
import de.pierreschwang.spigotlib.item.ItemFactory;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PinEnterInventory {
    private final PinloginPlugin plugin;
    private final PinUser user;
    private final SimpleInventory inventory;
    private int attempts = 0;
    private final StringBuilder enteredPin = new StringBuilder();

    public PinEnterInventory(PinloginPlugin plugin, PinUser user) {
        this.plugin = plugin;
        this.user = user;
        this.inventory = InventoryFactory.create(InventoryType.DISPENSER, user.getMessage("inventory-authorization-title", new Object[0]));
        this.reset();
    }

    public void open() {
        this.inventory.open(this.user.getPlayer());
    }

    public void onClose(Player player) {
        player.kickPlayer(this.user.getMessage("pin-not-entered", new Object[0]));
    }

    public void onNumberClick(int clicked) {
        this.enteredPin.append(clicked);
        if (this.enteredPin.length() < 4) {
            return;
        }
        InventoryConstants.TEXTURE_NUMBERS.forEach((number, texture) -> {
            ItemStack skull = ItemFactory.skull().texture((String)texture).name(this.user.getMessage("inventory-authorization-number", number)).apply();
            this.inventory.setItem(number - 1, skull, event -> {});
        });
        int pinNumberValue = Integer.parseInt(this.enteredPin.toString());
        this.user.getPin().whenComplete((pin, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                this.user.getPlayer().kickPlayer(throwable.getMessage());
                return;
            }
            if (pinNumberValue != pin) {
                ++this.attempts;
                if (this.attempts >= this.plugin.getPinConfig().getLoginAttemptsBeforeKick()) {
                    new BukkitRunnable(){

                        public void run() {
                            PinEnterInventory.this.user.getPlayer().kickPlayer(PinEnterInventory.this.user.getMessage("invalid-pin", new Object[0]));
                        }
                    }.runTask((Plugin)this.plugin);
                } else {
                    this.user.callSyncEvent((Event)new PinAuthorizationFailedEvent(this.user, this.user.getPlayer(), this.attempts));
                    this.user.getPlayer().playSound(this.user.getPlayer().getLocation(), Sound.ANVIL_BREAK, 1.0f, 1.0f);
                    this.user.sendMessage("invalid-pin-try-again", new Object[0]);
                    this.reset();
                }
                return;
            }
            this.user.callSyncEvent((Event)new PinAuthorizationSuccessEvent(this.user, this.user.getPlayer()));
            this.attempts = 0;
            this.inventory.setCloseListener(player -> {});
            this.user.setAuthorized(true);
            this.user.getPlayer().setWalkSpeed(0.2f);
            this.user.getPlayer().removePotionEffect(PotionEffectType.BLINDNESS);
            this.user.getPlayer().closeInventory();
            this.user.getPlayer().playSound(this.user.getPlayer().getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
        });
    }

    private void reset() {
        this.enteredPin.setLength(0);
        this.inventory.setCloseListener(this::onClose);
        InventoryConstants.TEXTURE_NUMBERS.forEach((number, texture) -> {
            ItemStack skull = ItemFactory.skull().texture((String)texture).name(this.user.getMessage("inventory-authorization-number", number)).apply();
            this.inventory.setItem(number - 1, skull, event -> this.onNumberClick((int)number));
        });
    }
}

