/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.utils;

import java.util.LinkedList;

public class ServerSystemTimer
implements Runnable {
    private final LinkedList<Double> history = new LinkedList();
    private transient long lastPoll = System.nanoTime();

    public ServerSystemTimer() {
        this.history.add(20.0);
    }

    @Override
    public void run() {
        double d;
        long startTime = System.nanoTime();
        long timeSpent = (startTime - this.lastPoll) / 1000L;
        if (timeSpent == 0L) {
            timeSpent = 1L;
        }
        if (this.history.size() > 10) {
            this.history.remove();
        }
        double tps = 5.0E7 / (double)timeSpent;
        if (d <= 21.0) {
            this.history.add(tps);
        }
        this.lastPoll = startTime;
    }

    public double getAverageTPS() {
        double avg = 0.0;
        for (Double f : this.history) {
            if (f == null) continue;
            avg += f.doubleValue();
        }
        return avg / (double)this.history.size();
    }
}

