/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.utils;

import java.io.File;
import java.io.IOException;
import me.clip.placeholderapi.PlaceholderAPI;
import me.entity303.serversystem.config.ConfigReader;
import me.entity303.serversystem.config.DefaultConfigReader;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;

public class Message {
    private final ServerSystem plugin;
    private final File messagesFile;
    private final ConfigReader cfg;
    private final boolean placeholderAPI;

    public Message(ServerSystem plugin) {
        this.plugin = plugin;
        this.messagesFile = new File("plugins//ServerSystem", "messages.yml");
        this.cfg = DefaultConfigReader.loadConfiguration(this.messagesFile);
        this.placeholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public String getMessage(String label, String command, CommandSender sender, CommandSender target, String action) {
        if (sender == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        if (target == null) {
            target = sender;
        }
        String senderName = sender.getName();
        String senderDisplayName = sender instanceof Player ? ((Player)sender).getDisplayName() : senderName;
        String targetName = target.getName();
        String targetDisplayName = target instanceof Player ? ((Player)target).getDisplayName() : targetName;
        if (senderName.equalsIgnoreCase("console") || senderName.equalsIgnoreCase("konsole")) {
            senderDisplayName = senderName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (targetName.equalsIgnoreCase("console") || targetName.equalsIgnoreCase("konsole")) {
            targetDisplayName = targetName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        try {
            String message = ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Normal." + action).replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<SENDERDISPLAY>", senderDisplayName).replace("<TARGETDISPLAY>", targetDisplayName).replace("<BREAK>", "\n"));
            return sender instanceof Player && this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)message) : message;
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Normal." + action;
        }
    }

    public String getMessageWithStringTarget(String label, String command, CommandSender sender, String target, String action) {
        String targetDisplayName;
        String targetName;
        if (sender == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        String senderName = sender.getName();
        String senderDisplayName = sender instanceof Player ? ((Player)sender).getDisplayName() : senderName;
        if (target == null) {
            targetName = senderName;
            targetDisplayName = senderDisplayName;
        } else {
            targetName = target;
            targetDisplayName = target;
        }
        if (senderName.equalsIgnoreCase("console") || senderName.equalsIgnoreCase("konsole")) {
            senderDisplayName = senderName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (targetName.equalsIgnoreCase("console") || targetName.equalsIgnoreCase("konsole")) {
            targetDisplayName = targetName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        try {
            String message = ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Normal." + action)).replace("<BREAK>", "\n").replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<SENDERDISPLAY>", senderDisplayName).replace("<TARGETDISPLAY>", targetDisplayName);
            return sender instanceof Player && this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)message) : message;
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Normal." + action;
        }
    }

    public String getMessage(String label, String command, String sender, CommandSender target, String action) {
        String targetDisplayName;
        String targetName;
        String senderName;
        if (sender == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        String senderDisplayName = senderName = sender;
        if (target != null) {
            targetName = target.getName();
            targetDisplayName = target instanceof Player ? ((Player)target).getDisplayName() : targetName;
        } else {
            targetName = senderName;
            targetDisplayName = senderDisplayName;
        }
        if (senderName.equalsIgnoreCase("console") || senderName.equalsIgnoreCase("konsole")) {
            senderDisplayName = senderName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (targetName.equalsIgnoreCase("console") || targetName.equalsIgnoreCase("konsole")) {
            targetDisplayName = targetName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        try {
            return ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Normal." + action).replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<SENDERDISPLAY>", senderDisplayName).replace("<TARGETDISPLAY>", targetDisplayName).replace("<BREAK>", "\n"));
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Normal." + action;
        }
    }

    public String getMiscMessage(String label, String command, CommandSender sender, CommandSender target, String action) {
        if (sender == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        if (target == null) {
            target = sender;
        }
        String senderName = sender.getName();
        String senderDisplayName = sender instanceof Player ? ((Player)sender).getDisplayName() : senderName;
        String targetName = target.getName();
        String targetDisplayName = target instanceof Player ? ((Player)target).getDisplayName() : targetName;
        if (senderName.equalsIgnoreCase("console") || senderName.equalsIgnoreCase("konsole")) {
            senderDisplayName = senderName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (targetName.equalsIgnoreCase("console") || targetName.equalsIgnoreCase("konsole")) {
            targetDisplayName = targetName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        try {
            String message = ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Misc." + action).replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<SENDERDISPLAY>", senderDisplayName).replace("<TARGETDISPLAY>", targetDisplayName).replace("<BREAK>", "\n"));
            return sender instanceof Player && this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)message) : message;
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Misc." + action;
        }
    }

    public String getMessage(String label, String command, CommandSender sender, CommandSender target, String action, boolean colorless) {
        if (sender == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        if (target == null) {
            target = sender;
        }
        String senderName = sender.getName();
        String senderDisplayName = sender instanceof Player ? ((Player)sender).getDisplayName() : senderName;
        String targetName = target.getName();
        String targetDisplayName = target instanceof Player ? ((Player)target).getDisplayName() : targetName;
        if (senderName.equalsIgnoreCase("console") || senderName.equalsIgnoreCase("konsole")) {
            senderDisplayName = senderName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (targetName.equalsIgnoreCase("console") || targetName.equalsIgnoreCase("konsole")) {
            targetDisplayName = targetName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (colorless) {
            try {
                return this.cfg.getString("Messages.Normal." + action).replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<SENDERDISPLAY>", senderDisplayName).replace("<TARGETDISPLAY>", targetDisplayName).replace("<BREAK>", "\n");
            }
            catch (NullPointerException ignored) {
                return "Error! Path: " + action;
            }
        }
        try {
            String message = ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Normal." + action).replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<BREAK>", "\n"));
            return sender instanceof Player && this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)message) : message;
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Normal." + action;
        }
    }

    public String getSyntax(String label, String command, CommandSender sender, CommandSender target, String action) {
        if (sender == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        if (target == null) {
            target = sender;
        }
        String senderName = sender.getName();
        String senderDisplayName = sender instanceof Player ? ((Player)sender).getDisplayName() : senderName;
        String targetName = target.getName();
        String targetDisplayName = target instanceof Player ? ((Player)target).getDisplayName() : targetName;
        if (senderName.equalsIgnoreCase("console") || senderName.equalsIgnoreCase("konsole")) {
            senderDisplayName = senderName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (targetName.equalsIgnoreCase("console") || targetName.equalsIgnoreCase("konsole")) {
            targetDisplayName = targetName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        try {
            String message = ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Syntax." + action)).replace("<BREAK>", "\n").replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<SENDERDISPLAY>", senderDisplayName).replace("<TARGETDISPLAY>", targetDisplayName);
            return sender instanceof Player && this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)message) : message;
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Syntax." + action;
        }
    }

    public String getSyntaxWithStringTarget(String label, String command, CommandSender sender, String target, String action) {
        String targetDisplayName;
        String targetName;
        if (sender == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        String senderName = sender.getName();
        String senderDisplayName = sender instanceof Player ? ((Player)sender).getDisplayName() : senderName;
        if (target == null) {
            targetName = senderName;
            targetDisplayName = senderDisplayName;
        } else {
            targetName = target;
            targetDisplayName = target;
        }
        if (senderName.equalsIgnoreCase("console") || senderName.equalsIgnoreCase("konsole")) {
            senderDisplayName = senderName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        if (targetName.equalsIgnoreCase("console") || targetName.equalsIgnoreCase("konsole")) {
            targetDisplayName = targetName = this.cfg.getString("Messages.Misc.BanSystem.ConsoleName");
        }
        try {
            String message = ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Syntax." + action)).replace("<BREAK>", "\n").replace("<LABEL>", label).replace("<COMMAND>", command).replace("<SENDER>", senderName).replace("<TARGET>", targetName).replace("<SENDERDISPLAY>", senderDisplayName).replace("<TARGETDISPLAY>", targetDisplayName);
            return sender instanceof Player && this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)message) : message;
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Syntax." + action;
        }
    }

    public ConfigReader getCfg() {
        return this.cfg;
    }

    public String getPrefix() {
        try {
            return ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Misc.Prefix").replace("<BREAK>", "\n"));
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Misc.Prefix";
        }
    }

    public String getNoPermission(String permission) {
        if (permission == null) {
            permission = "No permission found";
        }
        try {
            return ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Misc.NoPermissions").replace("<PERMISSION>", permission).replace("<BREAK>", "\n"));
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Misc.NoPermissions";
        }
    }

    public String getOnlyPlayer() {
        try {
            return ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Misc.OnlyPlayer")).replace("<BREAK>", "\n");
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Misc.OnlyPlayer";
        }
    }

    public String getNoTarget(String targetName) {
        try {
            return ChatColor.translateAlternateColorCodes('&', this.cfg.getString("Messages.Misc.NoTarget").replace("<TARGET>", targetName != null ? targetName : "null").replace("<TARGETDISPLAY>", targetName != null ? targetName : "null")).replace("<BREAK>", "\n");
        }
        catch (NullPointerException ignored) {
            return "Error! Path: Misc.NoTarget";
        }
    }

    public void reloadMessages() throws IOException, InvalidConfigurationException {
        this.cfg.load(this.messagesFile);
    }

    public boolean getBoolean(String fullAction) {
        return this.cfg.getBoolean(fullAction);
    }
}

