/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.entity303.serversystem.exceptions.NotDirectoryException;

public class FileUtils {
    public static void deleteDirectory(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            FileUtils.deleteFile(file);
            return;
        }
        for (File f : file.listFiles()) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory(f);
                continue;
            }
            FileUtils.deleteFile(f);
        }
        FileUtils.deleteFile(file);
    }

    public static void deleteFile(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new IOException("Couldn't delete file: " + file.getAbsolutePath());
        }
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        if (source == null) {
            return;
        }
        if (destination == null) {
            return;
        }
        if (!source.exists()) {
            throw new FileNotFoundException("File not found: " + source);
        }
        if (!source.isDirectory()) {
            FileUtils.copyFile(source, destination);
            return;
        }
        if (source.getCanonicalPath().equals(destination.getCanonicalPath())) {
            throw new IOException("Destination and source are the same!");
        }
        if (!destination.exists()) {
            if (!destination.mkdirs()) {
                throw new IOException("Could not copy file: " + source.getAbsolutePath() + "\nTo: " + destination.getAbsolutePath());
            }
            if (!destination.isDirectory()) {
                throw new NotDirectoryException("Destination is not a directory!");
            }
        }
        for (File file : source.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.copyDirectory(file, new File(destination, file.getName()));
                continue;
            }
            FileUtils.copyFile(file, new File(destination, file.getName()));
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (source == null) {
            return;
        }
        if (destination == null) {
            return;
        }
        if (!source.exists()) {
            throw new FileNotFoundException("File not found: " + source);
        }
        if (source.getCanonicalPath().equals(destination.getCanonicalPath())) {
            throw new IOException("Destination and source are the same!");
        }
        FileInputStream inputStream = new FileInputStream(source);
        FileOutputStream outputStream = new FileOutputStream(destination);
        int data = ((InputStream)inputStream).read();
        while (data != -1) {
            ((OutputStream)outputStream).write(data);
            data = ((InputStream)inputStream).read();
        }
        outputStream.flush();
        ((OutputStream)outputStream).close();
        ((InputStream)inputStream).close();
    }
}

