/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.entity303.serversystem.main.ServerSystem;

public enum ChatColor {
    BLACK,
    DARK_BLUE,
    DARK_GREEN,
    DARK_AQUA,
    DARK_RED,
    DARK_PURPLE,
    GOLD,
    GRAY,
    DARK_GRAY,
    BLUE,
    GREEN,
    AQUA,
    RED,
    LIGHT_PURPLE,
    YELLOW,
    WHITE,
    MAGIC,
    BOLD,
    STRIKETHROUGH,
    UNDERLINE,
    ITALIC,
    RESET;

    public static final char COLOR_CHAR = '\u00a7';
    public static final Pattern REPLACE_ALL_PATTERN;
    public static final String RGB_PATTERN;
    private static final Pattern STRIP_COLOR_PATTERN;
    private final org.bukkit.ChatColor chatColor = org.bukkit.ChatColor.valueOf((String)this.name());

    public static String of(String input) {
        String[] arr;
        StringBuilder inputBuilder = new StringBuilder("\u00a7x");
        for (String a : arr = input.split("")) {
            if (a.contains("#") || a.contains("&")) continue;
            inputBuilder.append(org.bukkit.ChatColor.getByChar((String)a));
        }
        input = inputBuilder.toString();
        return input;
    }

    public static String replaceHexColor(char altColorChar, String input) {
        Matcher matcher = Pattern.compile(RGB_PATTERN.replace("&", String.valueOf(altColorChar))).matcher(input);
        while (matcher.find()) {
            input = input.replace(matcher.group(), ChatColor.of(matcher.group()));
        }
        return input;
    }

    public static String translateAlternateColorCodes(char altColorChar, String textToTranslate) {
        if (textToTranslate.contains(altColorChar + "#")) {
            try {
                if (((ServerSystem)ServerSystem.getPlugin(ServerSystem.class)).getVersionManager().isV116()) {
                    textToTranslate = ChatColor.replaceHexColor(altColorChar, textToTranslate);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)altColorChar, (String)textToTranslate);
    }

    public org.bukkit.ChatColor getChatColor() {
        return this.chatColor;
    }

    public String toString() {
        return this.getChatColor().toString();
    }

    static {
        STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
        REPLACE_ALL_PATTERN = Pattern.compile("(&)?&([0-9a-fk-orA-FK-OR])");
        RGB_PATTERN = "(&)?&#([0-9a-fA-F]{6})";
    }
}

