/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.tabcompleter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.entity303.serversystem.bansystem.TimeUnit;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class BanTabCompleter
extends MessageUtils
implements TabCompleter {
    public BanTabCompleter(ServerSystem plugin) {
        super(plugin);
    }

    public List<String> onTabComplete(CommandSender cs, Command cmd, String label, String[] args) {
        if (!this.isAllowed(cs, "ban.use.general", true)) {
            return Collections.singletonList("");
        }
        if (args.length == 1) {
            return null;
        }
        if (args.length == 2) {
            if (this.isAllowed(cs, "ban.use.permanent")) {
                return Collections.singletonList(this.getBanSystem("PermanentName"));
            }
            return Collections.singletonList("");
        }
        if (args.length == 3) {
            ArrayList<String> timeUnitList = new ArrayList<String>();
            timeUnitList.add(TimeUnit.yearName);
            timeUnitList.add(TimeUnit.monthName);
            timeUnitList.add(TimeUnit.weekName);
            timeUnitList.add(TimeUnit.dayName);
            timeUnitList.add(TimeUnit.hourName);
            timeUnitList.add(TimeUnit.minuteName);
            timeUnitList.add(TimeUnit.secondName);
            List tabList = timeUnitList.stream().filter(timeUnit -> timeUnit.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            return tabList.isEmpty() ? timeUnitList : tabList;
        }
        return null;
    }
}

