/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.listener.command;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.commands.IEssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.entity303.serversystem.main.ServerSystem;
import net.ess3.api.IEssentials;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class EssentialsCommandListener
implements Listener {
    private final Essentials essentials;
    private final ServerSystem plugin;
    private final Map<String, String> essentialsCommandMap = new HashMap<String, String>();

    public EssentialsCommandListener(Essentials essentials, ServerSystem plugin) {
        this.essentials = essentials;
        this.plugin = plugin;
    }

    @EventHandler
    public void onNewEssentialsCommand(PlayerCommandPreprocessEvent e) {
        String com = e.getMessage().split(" ")[0].replaceFirst("/", "").toLowerCase();
        if (this.essentialsCommandMap.containsKey(com)) {
            IEssentialsCommand cmd;
            e.setCancelled(true);
            ArrayList<String> args = new ArrayList<String>();
            if (e.getMessage().split(" ").length >= 2) {
                for (int i = 1; i < e.getMessage().split(" ").length; ++i) {
                    args.add(i - 1, e.getMessage().split(" ")[i]);
                }
            }
            String command = this.essentialsCommandMap.get(com);
            PluginCommand essentialsCommand = this.plugin.getServer().getPluginCommand("essentials:" + command);
            try {
                cmd = (IEssentialsCommand)Essentials.class.getClassLoader().loadClass("com.earth2me.essentials.commands.Command" + essentialsCommand.getName()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException instantiationException) {
                if (!instantiationException.getMessage().isEmpty()) {
                    e.getPlayer().sendMessage(instantiationException.getMessage());
                }
                instantiationException.printStackTrace();
                return;
            }
            cmd.setEssentials((IEssentials)this.essentials);
            cmd.setEssentialsModule(null);
            try {
                cmd.run(this.essentials.getServer(), this.essentials.getUser(e.getPlayer().getUniqueId()), essentialsCommand.getName(), (Command)essentialsCommand, args.toArray(new String[0]));
            }
            catch (NotEnoughArgumentsException exception) {
                e.getPlayer().sendMessage(essentialsCommand.getDescription());
                e.getPlayer().sendMessage(essentialsCommand.getUsage().replaceAll("<command>", com));
                if (!exception.getMessage().isEmpty()) {
                    e.getPlayer().sendMessage(exception.getMessage());
                }
            }
            catch (Exception exception) {
                if (!exception.getMessage().isEmpty()) {
                    e.getPlayer().sendMessage(exception.getMessage());
                }
                exception.printStackTrace();
            }
        }
    }

    public void addCommand(String command, String essentialsCommand) {
        this.essentialsCommandMap.put(command.toLowerCase(), essentialsCommand.toLowerCase());
    }

    public void removeCommand(String command) {
        this.essentialsCommandMap.remove(command.toLowerCase());
    }

    public List<String> getNewEssentialsCommands() {
        return new ArrayList<String>(this.essentialsCommandMap.keySet());
    }
}

