/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.listener;

import java.util.UUID;
import me.entity303.serversystem.bansystem.Ban;
import me.entity303.serversystem.bansystem.ManagerBan;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.ChatColor;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class LoginListener
extends MessageUtils
implements Listener {
    public LoginListener(ServerSystem plugin) {
        super(plugin);
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent e) {
        if (this.plugin.isStarting()) {
            e.disallow(PlayerLoginEvent.Result.KICK_OTHER, ChatColor.translateAlternateColorCodes('&', this.plugin.getMessages().getCfg().getString("Messages.Misc.ServerStillStarting")));
        }
        if (this.plugin.isMaintenance() && !this.isAllowed((CommandSender)e.getPlayer(), "maintenance.join", true)) {
            e.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, this.getMessage("Maintenance.NoJoin", "Join", "Join", e.getPlayer().getName(), null));
            return;
        }
        ManagerBan banManager = this.plugin.getBanManager();
        if (banManager.isBanned(e.getPlayer().getUniqueId())) {
            Ban ban = banManager.getBanByPlayer((OfflinePlayer)e.getPlayer());
            if (ban.getUNBAN_TIME() > -1L && ban.getUNBAN_TIME() <= System.currentTimeMillis()) {
                this.plugin.getBanManager().unBan(e.getPlayer().getUniqueId());
                return;
            }
            String name = "Unknown";
            if (ban.getBAN_SENDER_UUID().equalsIgnoreCase(this.getBanSystem("ConsoleName"))) {
                name = this.getBanSystem("ConsoleName");
            } else {
                try {
                    OfflinePlayer player2 = Bukkit.getOfflinePlayer((UUID)UUID.fromString(ban.getBAN_SENDER_UUID()));
                    name = player2.getName();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            e.disallow(PlayerLoginEvent.Result.KICK_BANNED, this.getMessage("Ban.Kick", "login", "login", name, (CommandSender)e.getPlayer()).replace("<REASON>", ChatColor.translateAlternateColorCodes('&', ban.getBAN_REASON())).replace("<DATE>", ban.getUNBAN_DATE().replace("&", "\u00a7")));
        } else if (Bukkit.getMaxPlayers() <= Bukkit.getOnlinePlayers().size()) {
            if (!this.isAllowed((CommandSender)e.getPlayer(), "joinfullserver.premium", true) && !this.isAllowed((CommandSender)e.getPlayer(), "joinfullserver.admin", true)) {
                e.disallow(PlayerLoginEvent.Result.KICK_FULL, this.plugin.getMessages().getMiscMessage("ServerJoin", "ServerJoin", (CommandSender)e.getPlayer(), null, "ServerFull").replace("<PERMISSION>", this.Perm("joinfullserver")));
            } else {
                e.allow();
                if (this.isAllowed((CommandSender)e.getPlayer(), "joinfullserver.admin", true)) {
                    Player kickedPlayer = Bukkit.getOnlinePlayers().stream().filter(player -> player != e.getPlayer()).filter(player -> !this.isAllowed((CommandSender)player, "joinfullserver.admin", true)).findFirst().orElse(null);
                    String name = kickedPlayer.getName();
                    kickedPlayer.kickPlayer(this.getMessageWithStringTarget("KickedByHigher.Admin", "joinKick", "joinKick", (CommandSender)e.getPlayer(), name));
                } else if (this.isAllowed((CommandSender)e.getPlayer(), "joinfullserver.premium", true)) {
                    Player kickedPlayer = Bukkit.getOnlinePlayers().stream().filter(player -> player != e.getPlayer()).filter(player -> !this.isAllowed((CommandSender)player, "joinfullserver.premium", true) && !this.isAllowed((CommandSender)player, "joinfullserver.admin", true)).findFirst().orElse(null);
                    String name = kickedPlayer.getName();
                    kickedPlayer.kickPlayer(this.getMessageWithStringTarget("KickedByHigher.Premium", "joinKick", "joinKick", (CommandSender)e.getPlayer(), name));
                }
            }
        }
    }
}

