/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.listener;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;

public class EntitySpawnListener
extends MessageUtils
implements Listener {
    private Class entityLiving;
    private Field collidesField;
    private Method getHandleMethod;

    public EntitySpawnListener(ServerSystem plugin) {
        super(plugin);
        try {
            this.entityLiving = Class.forName("org.bukkit.craftbukkit." + plugin.getVersionManager().getNMSVersion() + ".entity.CraftLivingEntity");
            this.collidesField = !plugin.getVersionManager().isV117() ? Class.forName("net.minecraft.server." + plugin.getVersionManager().getNMSVersion() + ".EntityLiving").getDeclaredField("collides") : Class.forName("net.minecraft.world.entity.EntityLiving").getDeclaredField("collides");
            this.collidesField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getHandleMethod = Class.forName("org.bukkit.craftbukkit." + plugin.getVersionManager().getNMSVersion() + ".entity.CraftEntity").getDeclaredMethod("getHandle", new Class[0]);
            this.getHandleMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (this.getHandleMethod != null && this.collidesField != null) {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    Object handle = null;
                    try {
                        handle = this.getHandleMethod.invoke((Object)entity, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    try {
                        this.collidesField.set(handle, false);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent e) {
        if (this.collidesField == null || this.getHandleMethod == null) {
            HandlerList.unregisterAll((Listener)this);
            return;
        }
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        try {
            Object handle = this.getHandleMethod.invoke((Object)e.getEntity(), new Object[0]);
            this.collidesField.set(handle, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

