/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.economy;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.UUID;
import me.entity303.serversystem.economy.ManagerEconomy;
import me.entity303.serversystem.main.ServerSystem;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EconomyManager_SQLite
extends ManagerEconomy {
    private final String currencySingular;
    private final String currencyPlural;
    private final String startingMoney;
    private final String displayFormat;
    private final String moneyFormat;
    private final String separator;
    private Connection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EconomyManager_SQLite(String currencySingular, String currencyPlural, String startingMoney, String displayFormat, String moneyFormat, String separator, String thousands, ServerSystem plugin) {
        super(currencySingular, currencyPlural, startingMoney, displayFormat, moneyFormat, separator, thousands, plugin);
        this.currencySingular = currencySingular;
        this.currencyPlural = currencyPlural;
        this.separator = separator;
        this.displayFormat = displayFormat;
        this.startingMoney = startingMoney;
        this.moneyFormat = moneyFormat;
        this.open();
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS Economy (UUID VARCHAR(100), Balance DECIMAL(30, 2))");
            statement.close();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    protected boolean initialize() {
        try {
            Class.forName("org.sqlite.JDBC");
            return true;
        }
        catch (ClassNotFoundException var2) {
            this.plugin.error("Class not found in initialize(): " + var2);
            return false;
        }
    }

    public boolean open() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    return true;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.initialize()) {
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + new File("plugins//ServerSystem", "economy.sqlite").getAbsolutePath());
                return true;
            }
            catch (SQLException var2) {
                this.plugin.error("Could not establish an SQLite connection, SQLException: " + var2.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public String format(double money) {
        String moneyStr = String.format(Locale.US, "%1$,.2f", money);
        moneyStr = moneyStr.replace(",", "<THOUSAND>");
        String moneyString = moneyStr.split("\\.")[0] + "." + moneyStr.split("\\.")[1];
        String first = "0";
        String last = "00";
        try {
            first = moneyString.split("\\.")[0];
            last = moneyString.split("\\.")[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (last.length() == 1) {
            last = last + "0";
        }
        String formattedMoney = this.moneyFormat.replace("<FIRST>", first).replace("<LAST>", last).replace("<SEPARATOR>", this.separator).replace("<THOUSAND>", this.getThousands());
        return this.displayFormat.replace("<MONEY>", formattedMoney).replace("<CURRENCY>", money >= 2.0 ? this.currencyPlural : this.currencySingular);
    }

    @Override
    public boolean hasEnoughMoney(Player player, double amount) {
        return this.hasEnoughMoney((OfflinePlayer)player, amount);
    }

    @Override
    public void makeTransaction(Player sender, Player target, double amount) {
        this.makeTransaction((OfflinePlayer)sender, (OfflinePlayer)target, amount);
    }

    @Override
    public void setMoney(Player player, double amount) {
        this.setMoney((OfflinePlayer)player, amount);
    }

    @Override
    public void removeMoney(Player player, double amount) {
        this.removeMoney((OfflinePlayer)player, amount);
    }

    @Override
    public void addMoney(Player player, double amount) {
        this.addMoney((OfflinePlayer)player, amount);
    }

    @Override
    public void createAccount(Player player) {
        this.createAccount((OfflinePlayer)player);
    }

    @Override
    public boolean hasEnoughMoney(OfflinePlayer player, double amount) {
        if (player == null) {
            return false;
        }
        amount = Double.parseDouble(String.format("%.2f", amount).replace(",", "."));
        return this.getMoneyAsNumber(player) >= amount;
    }

    @Override
    public void makeTransaction(OfflinePlayer sender, OfflinePlayer target, double amount) {
        if (sender == null) {
            return;
        }
        if (target == null) {
            return;
        }
        amount = Double.parseDouble(String.format("%.2f", amount).replace(",", "."));
        this.removeMoney(sender, amount);
        this.addMoney(target, amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMoney(OfflinePlayer player, double amount) {
        block17: {
            this.open();
            double[] doubles = new double[]{amount};
            if (player == null) {
                return;
            }
            doubles[0] = Double.parseDouble(String.format("%.2f", doubles[0]).replace(",", "."));
            this.deleteAccountSync(player);
            Statement statement = null;
            try {
                this.open();
                statement = this.connection.createStatement();
                statement.executeUpdate("INSERT INTO `Economy` (UUID, Balance) VALUES ('" + player.getUniqueId() + "','" + doubles[0] + "')");
                statement.close();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
                if (statement == null) break block17;
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMoney(OfflinePlayer player, double amount) {
        block17: {
            this.open();
            double[] doubles = new double[]{amount};
            if (player == null) {
                return;
            }
            doubles[0] = Double.parseDouble(String.format("%.2f", doubles[0]).replace(",", "."));
            double balance = this.getMoneyAsNumber(player) - doubles[0];
            this.deleteAccountSync(player);
            Statement statement = null;
            try {
                this.open();
                statement = this.connection.createStatement();
                statement.executeUpdate("INSERT INTO `Economy` (UUID, Balance) VALUES ('" + player.getUniqueId() + "','" + balance + "')");
                statement.close();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
                if (statement == null) break block17;
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMoney(OfflinePlayer player, double amount) {
        block17: {
            this.open();
            double[] doubles = new double[]{amount};
            if (player == null) {
                return;
            }
            doubles[0] = Double.parseDouble(String.format("%.2f", doubles[0]).replace(",", "."));
            double balance = this.getMoneyAsNumber(player) + doubles[0];
            this.deleteAccountSync(player);
            Statement statement = null;
            try {
                this.open();
                statement = this.connection.createStatement();
                statement.executeUpdate("INSERT INTO `Economy` (UUID, Balance) VALUES ('" + player.getUniqueId() + "','" + balance + "')");
                statement.close();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
                if (statement == null) break block17;
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAccount(OfflinePlayer player) {
        block18: {
            if (this.hasAccount(player)) {
                return;
            }
            this.open();
            if (player == null) {
                return;
            }
            Statement statement = null;
            try {
                this.open();
                statement = this.connection.createStatement();
                statement.executeUpdate("INSERT INTO `Economy` (UUID, Balance) VALUES ('" + player.getUniqueId() + "','" + this.startingMoney + "')");
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
                if (statement == null) break block18;
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAccount(OfflinePlayer player) {
        block18: {
            if (!this.hasAccount(player)) {
                return;
            }
            this.open();
            if (player == null) {
                return;
            }
            Statement statement = null;
            try {
                this.open();
                statement = this.connection.createStatement();
                statement.executeUpdate("DELETE FROM Economy WHERE UUID='" + player.getUniqueId() + "'");
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
                if (statement == null) break block18;
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAccountSync(OfflinePlayer player) {
        block17: {
            this.open();
            if (player == null) {
                return;
            }
            Statement statement = null;
            try {
                this.open();
                statement = this.connection.createStatement();
                statement.executeUpdate("DELETE FROM Economy WHERE UUID='" + player.getUniqueId() + "'");
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
                if (statement == null) break block17;
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public Double getMoneyAsNumber(Player player) {
        return this.getMoneyAsNumber((OfflinePlayer)player);
    }

    @Override
    public String getMoney(Player player) {
        return this.getMoney((OfflinePlayer)player);
    }

    @Override
    public Double getMoneyAsNumber(OfflinePlayer player) {
        this.open();
        if (player == null) {
            return 0.0;
        }
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            this.open();
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM Economy WHERE UUID = '" + player.getUniqueId() + "'");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            if (statement != null) {
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return 0.0;
        }
        try {
            block29: {
                try {
                    if (!resultSet.isClosed()) break block29;
                    if (statement != null) {
                        try {
                            if (!statement.isClosed()) {
                                statement.close();
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    return 0.0;
                }
                catch (AbstractMethodError e) {
                    // empty catch block
                }
            }
            if (!resultSet.next()) {
                resultSet.close();
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                return 0.0;
            }
            Double money = Double.parseDouble(String.format("%.2f", resultSet.getDouble("Balance")).replace(",", "."));
            resultSet.close();
            if (statement != null) {
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return money;
        }
        catch (SQLException e) {
            if (!e.getMessage().toLowerCase().contains("closed")) {
                e.printStackTrace();
            }
            if (statement != null) {
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            return 0.0;
        }
    }

    @Override
    public String getMoney(OfflinePlayer player) {
        return this.format(this.getMoneyAsNumber(player));
    }

    @Override
    public boolean hasAccount(OfflinePlayer player) {
        this.open();
        if (player == null) {
            return false;
        }
        ResultSet rs = null;
        Statement statement = null;
        try {
            this.open();
            statement = this.connection.createStatement();
            rs = statement.executeQuery("SELECT * FROM Economy WHERE UUID = '" + player.getUniqueId() + "'");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            if (statement != null) {
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        try {
            block34: {
                if (rs == null) {
                    if (statement != null) {
                        try {
                            if (!statement.isClosed()) {
                                statement.close();
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    return false;
                }
                try {
                    if (!rs.isClosed()) break block34;
                    if (statement != null) {
                        try {
                            if (!statement.isClosed()) {
                                statement.close();
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    return false;
                }
                catch (AbstractMethodError e) {
                    // empty catch block
                }
            }
            if (!rs.next()) {
                rs.close();
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }
            String uuid = rs.getString("UUID");
            rs.close();
            if (statement != null) {
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return uuid != null;
        }
        catch (SQLException throwables) {
            if (!throwables.getMessage().toLowerCase().contains("closed")) {
                throwables.printStackTrace();
            }
            if (statement != null) {
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    @Override
    public void fetchTopTen() {
    }

    @Override
    public void close() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getMoneyFormat() {
        return this.moneyFormat;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String getStartingMoney() {
        return this.startingMoney;
    }

    @Override
    public String getDisplayFormat() {
        return this.displayFormat;
    }

    @Override
    public String getCurrencySingular() {
        return this.currencySingular;
    }

    @Override
    public String getCurrencyPlural() {
        return this.currencyPlural;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<OfflinePlayer, Double> getTopTen() {
        LinkedHashMap<OfflinePlayer, Double> topTen;
        block17: {
            this.open();
            topTen = new LinkedHashMap<OfflinePlayer, Double>();
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT * FROM Economy ORDER BY Balance desc LIMIT 10");
                while (resultSet.next()) {
                    UUID uuid = UUID.fromString(resultSet.getString("UUID"));
                    Double balance = Double.parseDouble(String.format("%.2f", resultSet.getDouble("Balance")).replace(",", "."));
                    topTen.put(Bukkit.getOfflinePlayer((UUID)uuid), balance);
                }
                resultSet.close();
                if (statement == null) break block17;
                try {
                    if (!statement.isClosed()) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        if (!statement.isClosed()) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return topTen;
    }
}

