/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.entity303.serversystem.commands.executable.AnvilCommand;
import me.entity303.serversystem.commands.executable.BackCommand;
import me.entity303.serversystem.commands.executable.BaltopCommand;
import me.entity303.serversystem.commands.executable.BanCommand;
import me.entity303.serversystem.commands.executable.BreakCommand;
import me.entity303.serversystem.commands.executable.BroadcastCommand;
import me.entity303.serversystem.commands.executable.BurnCommand;
import me.entity303.serversystem.commands.executable.CartographyCommand;
import me.entity303.serversystem.commands.executable.ChatCommand;
import me.entity303.serversystem.commands.executable.CheckgamemodeCommand;
import me.entity303.serversystem.commands.executable.CheckhealthCommand;
import me.entity303.serversystem.commands.executable.ClearChatCommand;
import me.entity303.serversystem.commands.executable.ClearEnderChestCommand;
import me.entity303.serversystem.commands.executable.ClearInventoryCommand;
import me.entity303.serversystem.commands.executable.CommandSpyCommand;
import me.entity303.serversystem.commands.executable.CreateKitCommand;
import me.entity303.serversystem.commands.executable.DayCommand;
import me.entity303.serversystem.commands.executable.DelHomeCommand;
import me.entity303.serversystem.commands.executable.DeleteKitCommand;
import me.entity303.serversystem.commands.executable.DeleteWarpCommand;
import me.entity303.serversystem.commands.executable.DisenchantCommand;
import me.entity303.serversystem.commands.executable.DisposalCommand;
import me.entity303.serversystem.commands.executable.DropCommand;
import me.entity303.serversystem.commands.executable.EconomyCommand;
import me.entity303.serversystem.commands.executable.EditSignCommand;
import me.entity303.serversystem.commands.executable.EditSignPlotSquaredCommand;
import me.entity303.serversystem.commands.executable.EnderChestCommand;
import me.entity303.serversystem.commands.executable.EssentialsConversionCommand;
import me.entity303.serversystem.commands.executable.ExtinguishCommand;
import me.entity303.serversystem.commands.executable.FeedCommand;
import me.entity303.serversystem.commands.executable.FlyCommand;
import me.entity303.serversystem.commands.executable.GameModeCommand;
import me.entity303.serversystem.commands.executable.GetPosCommand;
import me.entity303.serversystem.commands.executable.GmaCommand;
import me.entity303.serversystem.commands.executable.GmcCommand;
import me.entity303.serversystem.commands.executable.GmsCommand;
import me.entity303.serversystem.commands.executable.GmspCommand;
import me.entity303.serversystem.commands.executable.GodCommand;
import me.entity303.serversystem.commands.executable.GrindStoneCommand;
import me.entity303.serversystem.commands.executable.HatCommand;
import me.entity303.serversystem.commands.executable.HealCommand;
import me.entity303.serversystem.commands.executable.HealNewerCommand;
import me.entity303.serversystem.commands.executable.HomeCommand;
import me.entity303.serversystem.commands.executable.InteractCommand;
import me.entity303.serversystem.commands.executable.InvseeCommand;
import me.entity303.serversystem.commands.executable.IpCommand;
import me.entity303.serversystem.commands.executable.KickAllCommand;
import me.entity303.serversystem.commands.executable.KickCommand;
import me.entity303.serversystem.commands.executable.KitCommand;
import me.entity303.serversystem.commands.executable.LagCommand;
import me.entity303.serversystem.commands.executable.LightningCommand;
import me.entity303.serversystem.commands.executable.LoomCommand;
import me.entity303.serversystem.commands.executable.MaintenanceCommand;
import me.entity303.serversystem.commands.executable.MoneyCommand;
import me.entity303.serversystem.commands.executable.MsgCommand;
import me.entity303.serversystem.commands.executable.MsgToggleCommand;
import me.entity303.serversystem.commands.executable.MuteCommand;
import me.entity303.serversystem.commands.executable.NightCommand;
import me.entity303.serversystem.commands.executable.NoonCommand;
import me.entity303.serversystem.commands.executable.OfflineEnderChestCommand;
import me.entity303.serversystem.commands.executable.OfflineInvseeCommand;
import me.entity303.serversystem.commands.executable.OfflineTeleportCommand;
import me.entity303.serversystem.commands.executable.OfflineTeleportHereCommand;
import me.entity303.serversystem.commands.executable.PayCommand;
import me.entity303.serversystem.commands.executable.PickUpCommand;
import me.entity303.serversystem.commands.executable.PingCommand;
import me.entity303.serversystem.commands.executable.RainCommand;
import me.entity303.serversystem.commands.executable.RecipeCommand;
import me.entity303.serversystem.commands.executable.RenameCommand;
import me.entity303.serversystem.commands.executable.RepairCommand;
import me.entity303.serversystem.commands.executable.ReplyCommand;
import me.entity303.serversystem.commands.executable.RestartCommand;
import me.entity303.serversystem.commands.executable.RulesCommand;
import me.entity303.serversystem.commands.executable.SeenCommand;
import me.entity303.serversystem.commands.executable.ServerSystemCommand;
import me.entity303.serversystem.commands.executable.SetHomeCommand;
import me.entity303.serversystem.commands.executable.SetSpawnCommand;
import me.entity303.serversystem.commands.executable.SetWarpCommand;
import me.entity303.serversystem.commands.executable.SignCommand;
import me.entity303.serversystem.commands.executable.SmeltCommand;
import me.entity303.serversystem.commands.executable.SmithingTableCommand;
import me.entity303.serversystem.commands.executable.SocialSpyCommand;
import me.entity303.serversystem.commands.executable.SpawnCommand;
import me.entity303.serversystem.commands.executable.SpeedCommand;
import me.entity303.serversystem.commands.executable.StackCommand;
import me.entity303.serversystem.commands.executable.StoneCutterCommand;
import me.entity303.serversystem.commands.executable.SudoCommand;
import me.entity303.serversystem.commands.executable.SuicideCommand;
import me.entity303.serversystem.commands.executable.SunCommand;
import me.entity303.serversystem.commands.executable.TeamChatCommand;
import me.entity303.serversystem.commands.executable.TeleportAllCommand;
import me.entity303.serversystem.commands.executable.TeleportCommand;
import me.entity303.serversystem.commands.executable.TeleportForceCommand;
import me.entity303.serversystem.commands.executable.TeleportForceHereCommand;
import me.entity303.serversystem.commands.executable.TeleportHereCommand;
import me.entity303.serversystem.commands.executable.TeleportPositionCommand;
import me.entity303.serversystem.commands.executable.TeleportRequestAcceptCommand;
import me.entity303.serversystem.commands.executable.TeleportRequestCommand;
import me.entity303.serversystem.commands.executable.TeleportRequestDenyCommand;
import me.entity303.serversystem.commands.executable.TeleportRequestHereCommand;
import me.entity303.serversystem.commands.executable.TeleportToggleCommand;
import me.entity303.serversystem.commands.executable.TimeCommand;
import me.entity303.serversystem.commands.executable.UnBanCommand;
import me.entity303.serversystem.commands.executable.UnMuteCommand;
import me.entity303.serversystem.commands.executable.UnSignCommand;
import me.entity303.serversystem.commands.executable.UnlimitedCommand;
import me.entity303.serversystem.commands.executable.VanishCommand;
import me.entity303.serversystem.commands.executable.WarpCommand;
import me.entity303.serversystem.commands.executable.WarpsCommand;
import me.entity303.serversystem.commands.executable.WeatherCommand;
import me.entity303.serversystem.commands.executable.WorkbenchCommand;
import me.entity303.serversystem.config.ConfigReader;
import me.entity303.serversystem.config.DefaultConfigReader;
import me.entity303.serversystem.listener.plotsquared.PlotListener;
import me.entity303.serversystem.listener.plotsquared.PlotListener1;
import me.entity303.serversystem.listener.plotsquared.PlotListener2;
import me.entity303.serversystem.listener.plotsquared.PlotListener3;
import me.entity303.serversystem.listener.plotsquared.PlotListener4;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.tabcompleter.BanTabCompleter;
import me.entity303.serversystem.tabcompleter.DefaultTabCompleter;
import me.entity303.serversystem.tabcompleter.DelHomeTabCompleter;
import me.entity303.serversystem.tabcompleter.DeleteKitTabCompleter;
import me.entity303.serversystem.tabcompleter.EconomyTabCompleter;
import me.entity303.serversystem.tabcompleter.GameModeTabCompleter;
import me.entity303.serversystem.tabcompleter.HomeTabCompleter;
import me.entity303.serversystem.tabcompleter.KitTabCompleter;
import me.entity303.serversystem.tabcompleter.MuteTabCompleter;
import me.entity303.serversystem.tabcompleter.RecipeTabCompleter;
import me.entity303.serversystem.tabcompleter.ServerSystemTabCompleter;
import me.entity303.serversystem.tabcompleter.SpeedTabCompleter;
import me.entity303.serversystem.tabcompleter.UnBanTabCompleter;
import me.entity303.serversystem.tabcompleter.UnMuteTabCompleter;
import me.entity303.serversystem.tabcompleter.WarpTabCompleter;
import me.entity303.serversystem.tabcompleter.WorldTabCompleter;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public final class CommandManager {
    private final ServerSystem serverSystem;
    private final List<String> serverSystemCommands = new ArrayList<String>();
    private final Map<String, PluginCommand> deactivatedBukkitCommands = new HashMap<String, PluginCommand>();
    private final Map<String, Command> deactivatedMiscCommands = new HashMap<String, Command>();
    private boolean dropActive = true;
    private boolean pickupActive = true;
    private boolean interactActive = true;
    private boolean chatActive = true;

    public CommandManager(ServerSystem serverSystem) {
        this.serverSystem = serverSystem;
    }

    public void rtc(String command, TabCompleter completer) {
        if (this.serverSystem.getCommand(command) != null) {
            this.serverSystem.getCommand(command).setTabCompleter(completer);
        }
    }

    public Command getCommand(String command) {
        CommandMap result = null;
        result = this.getCommandMap();
        SimpleCommandMap commandMap = (SimpleCommandMap)result;
        return commandMap.getCommand(command.toLowerCase(Locale.ROOT));
    }

    public void rc(String command, CommandExecutor executor, TabCompleter tabCompleter) {
        File commandsFiles;
        ConfigReader commandsConfig;
        if (executor == null) {
            System.out.println("Executor!");
        }
        if (command == null) {
            System.out.println("Command?!");
        }
        if (tabCompleter == null) {
            tabCompleter = executor instanceof TabCompleter ? (TabCompleter)executor : new DefaultTabCompleter(this.serverSystem);
        }
        if ((commandsConfig = DefaultConfigReader.loadConfiguration(commandsFiles = new File("plugins//ServerSystem", "commands.yml"))).getBoolean(command.toLowerCase())) {
            this.registerCommand(executor, (TabCompleter)tabCompleter, (Plugin)this.serverSystem, new String[]{command});
            this.serverSystemCommands.add(command.toLowerCase());
            File aliasFiles = new File("plugins//ServerSystem", "aliases.yml");
            ConfigReader aliasConfig = DefaultConfigReader.loadConfiguration(aliasFiles);
            String aliasString = aliasConfig.getString("Aliases." + command.toLowerCase() + ".aliases");
            if (aliasString != null) {
                if (!aliasString.equalsIgnoreCase("No Aliases")) {
                    String[] aliases = aliasConfig.getString("Aliases." + command.toLowerCase() + ".aliases").replace(" ", "").toLowerCase().split(",");
                    this.addAlias(command, executor, aliases);
                    this.serverSystemCommands.addAll(Arrays.asList(aliases));
                }
            } else {
                this.serverSystem.warn("Null alias for: " + command);
            }
        } else if (command.equalsIgnoreCase("drop")) {
            this.dropActive = false;
        } else if (command.equalsIgnoreCase("chat")) {
            this.chatActive = false;
        } else if (command.equalsIgnoreCase("pickup")) {
            this.pickupActive = false;
        } else if (command.equalsIgnoreCase("interact")) {
            this.interactActive = false;
        }
    }

    private Object getPrivateField(Object object, String field) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        String version = this.serverSystem.getVersionManager().getVersion();
        try {
            Field objectField = field.equals("commandMap") ? clazz.getDeclaredField(field) : (field.equals("knownCommands") ? (this.serverSystem.getVersionManager().isV113() ? clazz.getSuperclass().getDeclaredField(field) : clazz.getDeclaredField(field)) : null);
            objectField.setAccessible(true);
            return objectField.get(object);
        }
        catch (NoSuchFieldError | NoSuchFieldException ignored) {
            for (Field field1 : this.getClass().getDeclaredFields()) {
                System.out.println(field1.getName() + " -> " + field1.getType().getName());
            }
            return null;
        }
    }

    public void registerCommand(CommandExecutor executor, TabCompleter tabCompleter, Plugin plugin, String ... aliases) {
        if (this.serverSystem.getServer().getPluginCommand(aliases[0]) != null && !this.serverSystem.getServer().getPluginCommand(aliases[0]).getPlugin().getName().equalsIgnoreCase("ServerSystem")) {
            this.deactivateBukkitCommand(aliases[0], this.serverSystem.getServer().getPluginCommand(aliases[0]).getPlugin().getName());
        }
        Object map = null;
        try {
            map = this.getPrivateField(this.getCommandMap(), "knownCommands");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        HashMap knownCommands = (HashMap)map;
        aliases = (String[])Arrays.stream(aliases).map(String::toLowerCase).toArray(String[]::new);
        PluginCommand command = this.getNewCommand(aliases[0], plugin);
        command.setExecutor(executor);
        if (tabCompleter != null) {
            command.setTabCompleter(tabCompleter);
        }
        for (String alias : aliases) {
            knownCommands.remove(alias.toLowerCase());
        }
        for (String alias : aliases) {
            alias = alias.toLowerCase();
            knownCommands.put("serversystem:" + alias.toLowerCase(), command);
            knownCommands.put(alias.toLowerCase(), command);
        }
        command.register(this.getCommandMap());
    }

    private PluginCommand getNewCommand(String name, Plugin plugin) {
        PluginCommand command = null;
        try {
            Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            c.setAccessible(true);
            command = (PluginCommand)c.newInstance(name, plugin);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return command;
    }

    private void addAlias(String cmd, CommandExecutor executor, String[] aliases) {
        cmd = cmd.toLowerCase();
        try {
            CommandMap result = null;
            result = this.getCommandMap();
            SimpleCommandMap commandMap = (SimpleCommandMap)result;
            Object map = this.getPrivateField(commandMap, "knownCommands");
            HashMap knownCommands = (HashMap)map;
            for (String alias : aliases) {
                knownCommands.remove(alias.toLowerCase());
                knownCommands.remove("serversystem:" + alias.toLowerCase());
            }
            PluginCommand command = this.getNewCommand(cmd.toLowerCase(), (Plugin)this.serverSystem);
            command.setExecutor(executor);
            command.setAliases(Arrays.asList((String[])aliases.clone()));
            for (String alias : aliases) {
                alias = alias.toLowerCase();
                knownCommands.put(alias.toLowerCase(), command);
                knownCommands.put("serversystem:" + alias.toLowerCase(), command);
            }
            command.register((CommandMap)commandMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deactivateOwnCommand(String cmd) {
        try {
            String plugin = "serversystem";
            CommandMap result = this.getCommandMap();
            SimpleCommandMap commandMap = (SimpleCommandMap)result;
            Object map = this.getPrivateField(commandMap, "knownCommands");
            HashMap knownCommands = (HashMap)map;
            if (cmd == null) {
                return;
            }
            if (this.serverSystem.getServer().getPluginCommand(plugin + ":" + cmd) == this.serverSystem.getServer().getPluginCommand(cmd)) {
                knownCommands.remove(cmd);
            }
            knownCommands.remove(plugin + ":" + cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deactivateBukkitCommand(String cmd, String plugin) {
        try {
            CommandMap result = this.getCommandMap();
            SimpleCommandMap commandMap = (SimpleCommandMap)result;
            Object map = this.getPrivateField(commandMap, "knownCommands");
            HashMap knownCommands = (HashMap)map;
            if (cmd == null) {
                return;
            }
            if (plugin == null) {
                return;
            }
            if (this.serverSystem.getServer().getPluginCommand(plugin + ":" + cmd) == this.serverSystem.getServer().getPluginCommand(cmd)) {
                knownCommands.remove(cmd);
            }
            if (!(plugin.equalsIgnoreCase("minecraft") || plugin.equalsIgnoreCase("bukkit") || plugin.equalsIgnoreCase("spigot"))) {
                knownCommands.remove(plugin + ":" + cmd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void activateBukkitCommand(PluginCommand cmd) {
        try {
            CommandMap result = this.getCommandMap();
            SimpleCommandMap commandMap = (SimpleCommandMap)result;
            Object map = this.getPrivateField(commandMap, "knownCommands");
            HashMap knownCommands = (HashMap)map;
            if (cmd == null) {
                return;
            }
            knownCommands.put(cmd.getName().toLowerCase(), cmd);
            knownCommands.put(cmd.getPlugin().getName().toLowerCase() + ":" + cmd.getName().toLowerCase(), cmd);
            if (cmd.getAliases().size() > 0) {
                for (String alias : cmd.getAliases()) {
                    knownCommands.put(alias.toLowerCase(), cmd);
                    if (Bukkit.getServer().getPluginCommand(alias.toLowerCase().toLowerCase()) != null) continue;
                    knownCommands.put(cmd.getPlugin().getName().toLowerCase() + ":" + alias.toLowerCase(), cmd);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregisterCommands() {
        if (this.deactivatedBukkitCommands.size() > 0) {
            for (Map.Entry entry : this.deactivatedBukkitCommands.entrySet()) {
                String cmd = (String)entry.getKey();
                String plugin = cmd.split(":")[0];
                String command = cmd.split(":")[1];
                this.serverSystem.log("Reactivating command " + command + " from " + plugin + "!");
                this.activateBukkitCommand(this.deactivatedBukkitCommands.get(cmd));
            }
            if (this.serverSystem.getEssentialsCommandListener() != null) {
                for (String string : this.serverSystem.getEssentialsCommandListener().getNewEssentialsCommands()) {
                    this.serverSystem.log("Reactivating command " + string + "!");
                    this.serverSystem.getEssentialsCommandListener().removeCommand(string);
                }
            }
        }
        try {
            for (String string : this.serverSystemCommands) {
                String string2 = string.toLowerCase();
                this.deactivateOwnCommand(string2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerCommands() {
        this.rc("unlimited", new UnlimitedCommand(this.serverSystem), null);
        this.rc("clearchat", new ClearChatCommand(this.serverSystem), null);
        this.rc("back", new BackCommand(this.serverSystem), null);
        this.rc("broadcast", new BroadcastCommand(this.serverSystem), null);
        this.rc("sethome", new SetHomeCommand(this.serverSystem), null);
        this.rc("delhome", new DelHomeCommand(this.serverSystem), new DelHomeTabCompleter(this.serverSystem));
        this.rc("home", new HomeCommand(this.serverSystem), new HomeTabCompleter(this.serverSystem));
        this.rc("workbench", new WorkbenchCommand(this.serverSystem), null);
        this.rc("tpa", new TeleportRequestCommand(this.serverSystem), null);
        this.rc("tpahere", new TeleportRequestHereCommand(this.serverSystem), null);
        this.rc("tpaccept", new TeleportRequestAcceptCommand(this.serverSystem), null);
        this.rc("tpdeny", new TeleportRequestDenyCommand(this.serverSystem), null);
        this.rc("vanish", new VanishCommand(this.serverSystem), null);
        this.rc("chat", new ChatCommand(this.serverSystem), null);
        this.rc("interact", new InteractCommand(this.serverSystem), null);
        this.rc("pickup", new PickUpCommand(this.serverSystem), null);
        this.rc("drop", new DropCommand(this.serverSystem), null);
        this.rc("tptoggle", new TeleportToggleCommand(this.serverSystem), null);
        this.rc("clearenderchest", new ClearEnderChestCommand(this.serverSystem), null);
        this.rc("clearinventory", new ClearInventoryCommand(this.serverSystem), null);
        this.rc("checkgamemode", new CheckgamemodeCommand(this.serverSystem), null);
        this.rc("speed", new SpeedCommand(this.serverSystem), new SpeedTabCompleter(this.serverSystem));
        this.rc("serversystem", new ServerSystemCommand(this.serverSystem), new ServerSystemTabCompleter(this.serverSystem));
        this.rc("gamemode", new GameModeCommand(this.serverSystem), new GameModeTabCompleter());
        this.rc("gmc", new GmcCommand(this.serverSystem), null);
        this.rc("gms", new GmsCommand(this.serverSystem), null);
        this.rc("gma", new GmaCommand(this.serverSystem), null);
        this.rc("gmsp", new GmspCommand(this.serverSystem), null);
        this.rc("feed", new FeedCommand(this.serverSystem), null);
        this.rc("time", new TimeCommand(this.serverSystem), new WorldTabCompleter());
        this.rc("heal", (CommandExecutor)(this.serverSystem.getVersionManager().is188() ? new HealCommand(this.serverSystem) : new HealNewerCommand(this.serverSystem)), null);
        this.rc("hat", new HatCommand(this.serverSystem), null);
        this.rc("weather", new WeatherCommand(this.serverSystem), new WorldTabCompleter());
        this.rc("day", new DayCommand(this.serverSystem), new WorldTabCompleter());
        this.rc("night", new NightCommand(this.serverSystem), new WorldTabCompleter());
        this.rc("restart", new RestartCommand(this.serverSystem), null);
        this.rc("noon", new NoonCommand(this.serverSystem), new WorldTabCompleter());
        this.rc("ping", new PingCommand(this.serverSystem), null);
        this.rc("burn", new BurnCommand(this.serverSystem), null);
        this.rc("ip", new IpCommand(this.serverSystem), null);
        this.rc("repair", new RepairCommand(this.serverSystem), null);
        this.rc("disenchant", new DisenchantCommand(this.serverSystem), null);
        this.rc("suicide", new SuicideCommand(this.serverSystem), null);
        this.rc("extinguish", new ExtinguishCommand(this.serverSystem), null);
        this.rc("lag", new LagCommand(this.serverSystem), null);
        this.rc("sudo", new SudoCommand(this.serverSystem), null);
        this.rc("smelt", new SmeltCommand(this.serverSystem), null);
        this.rc("stack", new StackCommand(this.serverSystem), null);
        this.rc("sun", new SunCommand(this.serverSystem), new WorldTabCompleter());
        this.rc("rain", new RainCommand(this.serverSystem), new WorldTabCompleter());
        this.rc("disposal", new DisposalCommand(this.serverSystem), null);
        this.rc("editsign", (CommandExecutor)(Bukkit.getPluginManager().getPlugin("PlotSquared") != null ? new EditSignPlotSquaredCommand(this.serverSystem) : new EditSignCommand(this.serverSystem)), null);
        this.rc("teamchat", new TeamChatCommand(this.serverSystem), null);
        this.rc("sign", new SignCommand(this.serverSystem), null);
        this.rc("unsign", new UnSignCommand(this.serverSystem), null);
        this.rc("tppos", new TeleportPositionCommand(this.serverSystem), null);
        if (this.serverSystem.getConfigReader().getBoolean("bansystem.enabled")) {
            this.rc("ban", new BanCommand(this.serverSystem), new BanTabCompleter(this.serverSystem));
            this.rc("unban", new UnBanCommand(this.serverSystem), new UnBanTabCompleter(this.serverSystem));
            this.rc("mute", new MuteCommand(this.serverSystem), new MuteTabCompleter(this.serverSystem));
            this.rc("unmute", new UnMuteCommand(this.serverSystem), new UnMuteTabCompleter(this.serverSystem));
            this.rc("kick", new KickCommand(this.serverSystem), null);
            this.rc("kickall", new KickAllCommand(this.serverSystem), null);
        }
        if (this.serverSystem.getConfigReader().getBoolean("economy.enabled")) {
            this.rc("money", new MoneyCommand(this.serverSystem), null);
            this.rc("pay", new PayCommand(this.serverSystem), null);
            this.rc("economy", new EconomyCommand(this.serverSystem), new EconomyTabCompleter(this.serverSystem));
            this.rc("baltop", new BaltopCommand(this.serverSystem), null);
        }
        this.rc("fly", new FlyCommand(this.serverSystem), null);
        this.rc("commandspy", new CommandSpyCommand(this.serverSystem), null);
        this.rc("warp", new WarpCommand(this.serverSystem), new WarpTabCompleter(this.serverSystem));
        this.rc("delwarp", new DeleteWarpCommand(this.serverSystem), new WarpTabCompleter(this.serverSystem));
        this.rc("setwarp", new SetWarpCommand(this.serverSystem), null);
        this.rc("setspawn", new SetSpawnCommand(this.serverSystem), null);
        this.rc("spawn", new SpawnCommand(this.serverSystem), null);
        this.rc("createkit", new CreateKitCommand(this.serverSystem), null);
        this.rc("delkit", new DeleteKitCommand(this.serverSystem), new DeleteKitTabCompleter(this.serverSystem));
        this.rc("kit", new KitCommand(this.serverSystem), new KitTabCompleter(this.serverSystem));
        this.rc("invsee", new InvseeCommand(this.serverSystem), null);
        this.rc("enderchest", new EnderChestCommand(this.serverSystem), null);
        this.rc("tp", new TeleportCommand(this.serverSystem), null);
        this.rc("tpo", new TeleportForceCommand(this.serverSystem), null);
        this.rc("tphere", new TeleportHereCommand(this.serverSystem), null);
        this.rc("tpohere", new TeleportForceHereCommand(this.serverSystem), null);
        this.rc("tpall", new TeleportAllCommand(this.serverSystem), null);
        this.rc("msg", new MsgCommand(this.serverSystem), null);
        this.rc("msgtoggle", new MsgToggleCommand(this.serverSystem), null);
        this.rc("socialspy", new SocialSpyCommand(this.serverSystem), null);
        if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
            this.rc("convertfromessentials", new EssentialsConversionCommand(this.serverSystem), null);
        }
        this.rc("god", new GodCommand(this.serverSystem), null);
        this.rc("reply", new ReplyCommand(this.serverSystem), null);
        this.rc("maintenance", new MaintenanceCommand(this.serverSystem), null);
        this.rc("rules", new RulesCommand(this.serverSystem), null);
        this.rc("rename", new RenameCommand(this.serverSystem), null);
        this.rc("recipe", new RecipeCommand(this.serverSystem), new RecipeTabCompleter(this.serverSystem));
        this.rc("warps", new WarpsCommand(this.serverSystem), null);
        this.rc("checkhealth", new CheckhealthCommand(this.serverSystem), null);
        this.rc("lightning", new LightningCommand(this.serverSystem), null);
        this.rc("getpos", new GetPosCommand(this.serverSystem), null);
        this.rc("anvil", new AnvilCommand(this.serverSystem), null);
        if (this.serverSystem.getVersionStuff().getVirtualCartography() != null) {
            this.rc("cartographytable", new CartographyCommand(this.serverSystem), null);
        }
        if (this.serverSystem.getVersionStuff().getVirtualGrindstone() != null) {
            this.rc("grindstone", new GrindStoneCommand(this.serverSystem), null);
        }
        if (this.serverSystem.getVersionStuff().getVirtualLoom() != null) {
            this.rc("loom", new LoomCommand(this.serverSystem), null);
        }
        if (this.serverSystem.getVersionStuff().getVirtualStoneCutter() != null) {
            this.rc("stonecutter", new StoneCutterCommand(this.serverSystem), null);
        }
        if (this.serverSystem.getVersionStuff().getVirtualSmithing() != null) {
            this.rc("smithingtable", new SmithingTableCommand(this.serverSystem), null);
        }
        this.rc("break", new BreakCommand(this.serverSystem), null);
        this.rc("offlineteleport", (CommandExecutor)new OfflineTeleportCommand(this.serverSystem), null);
        this.rc("offlineteleporthere", (CommandExecutor)new OfflineTeleportHereCommand(this.serverSystem), null);
        this.rc("offlineinvsee", (CommandExecutor)new OfflineInvseeCommand(this.serverSystem), null);
        this.rc("offlineenderchest", (CommandExecutor)new OfflineEnderChestCommand(this.serverSystem), null);
        this.rc("seen", (CommandExecutor)new SeenCommand(this.serverSystem), null);
        boolean plotSquaredAlreadyRegistered = false;
        try {
            Class.forName("com.plotsquared.core.PlotAPI");
            new PlotListener4();
            new PlotListener(this.serverSystem);
            plotSquaredAlreadyRegistered = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!plotSquaredAlreadyRegistered) {
            try {
                Class.forName("com.plotsquared.core.events.PlayerEnterPlotEvent");
                new PlotListener3();
                new PlotListener(this.serverSystem);
                plotSquaredAlreadyRegistered = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!plotSquaredAlreadyRegistered) {
            try {
                Class.forName("com.github.intellectualsites.plotsquared.bukkit.events.PlayerEnterPlotEvent");
                Bukkit.getPluginManager().registerEvents((Listener)new PlotListener2(this.serverSystem), (Plugin)this.serverSystem);
                new PlotListener(this.serverSystem);
                plotSquaredAlreadyRegistered = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!plotSquaredAlreadyRegistered) {
            try {
                Class.forName("com.plotsquared.bukkit.events.PlayerEnterPlotEvent");
                Bukkit.getPluginManager().registerEvents((Listener)new PlotListener1(this.serverSystem), (Plugin)this.serverSystem);
                new PlotListener(this.serverSystem);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isDropActive() {
        return this.dropActive;
    }

    public boolean isPickupActive() {
        return this.pickupActive;
    }

    public boolean isInteractActive() {
        return this.interactActive;
    }

    public boolean isChatActive() {
        return this.chatActive;
    }

    private CommandMap getCommandMap() {
        CommandMap commandMap = null;
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field f = ((SimplePluginManager)Bukkit.getPluginManager()).getClass().getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(this.serverSystem.getServer().getPluginManager());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            if (e instanceof NoSuchFieldException) {
                try {
                    Field f = SimplePluginManager.class.getDeclaredField("commandMap");
                    f.setAccessible(true);
                    commandMap = (CommandMap)f.get(this.serverSystem.getServer().getPluginManager());
                    return commandMap;
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
            e.printStackTrace();
        }
        return commandMap;
    }
}

