/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.ChatColor;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpeedCommand
extends MessageUtils
implements CommandExecutor {
    public SpeedCommand(ServerSystem plugin) {
        super(plugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        Player target;
        if (!this.isAllowed(cs, "speed.general")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("speed.general")));
            return true;
        }
        if (args.length == 0) {
            cs.sendMessage(this.getPrefix() + this.getSyntax("Speed", label, cmd.getName(), cs, null));
            return true;
        }
        float speed = -1.0f;
        boolean isFly = false;
        Player player = null;
        if (args.length == 1) {
            if (!(cs instanceof Player)) {
                cs.sendMessage(this.getPrefix() + this.getSyntax("Speed", label, cmd.getName(), cs, null));
                return true;
            }
            player = (Player)cs;
            isFly = ((Player)cs).isFlying();
            try {
                speed = this.getRealMoveSpeed(this.getMoveSpeed(Float.parseFloat(args[0])), isFly);
            }
            catch (NumberFormatException ignored) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Speed.NotANumber", label, cmd.getName(), cs, null));
                return true;
            }
        }
        if (args.length == 2) {
            target = this.getPlayer(cs, args[1]);
            if (target == null) {
                if ("walk".equalsIgnoreCase(args[1]) || "laufen".equalsIgnoreCase(args[1]) || "walking".equalsIgnoreCase(args[1]) || "lauf".equalsIgnoreCase(args[1]) || "run".equalsIgnoreCase(args[1]) || "running".equalsIgnoreCase(args[1]) || "gehen".equalsIgnoreCase(args[1])) {
                    if (!(cs instanceof Player)) {
                        cs.sendMessage(this.getPrefix() + this.getSyntax("Speed", label, cmd.getName(), cs, null));
                        return true;
                    }
                    isFly = false;
                    player = (Player)cs;
                } else {
                    if (!("fly".equalsIgnoreCase(args[1]) || "flying".equalsIgnoreCase(args[1]) || "flight".equalsIgnoreCase(args[1]) || "flug".equalsIgnoreCase(args[1]) || "fliegen".equalsIgnoreCase(args[1]))) {
                        cs.sendMessage(this.getPrefix() + this.getNoTarget(args[1]));
                        return true;
                    }
                    if (!(cs instanceof Player)) {
                        cs.sendMessage(this.getPrefix() + this.getSyntax("Speed", label, cmd.getName(), cs, null));
                        return true;
                    }
                    isFly = true;
                    player = (Player)cs;
                }
            } else {
                player = target;
            }
            try {
                speed = this.getRealMoveSpeed(this.getMoveSpeed(Float.parseFloat(args[0])), isFly);
            }
            catch (NumberFormatException ignored) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Speed.NotANumber", label, cmd.getName(), cs, null));
                return true;
            }
        }
        if (args.length >= 3) {
            target = this.getPlayer(cs, args[1]);
            if (target == null) {
                cs.sendMessage(this.getPrefix() + this.getNoTarget(args[1]));
                return true;
            }
            player = target;
            if ("walk".equalsIgnoreCase(args[2]) || "laufen".equalsIgnoreCase(args[2]) || "walking".equalsIgnoreCase(args[2]) || "lauf".equalsIgnoreCase(args[2]) || "run".equalsIgnoreCase(args[2]) || "running".equalsIgnoreCase(args[2]) || "gehen".equalsIgnoreCase(args[2])) {
                isFly = false;
            } else {
                if (!("fly".equalsIgnoreCase(args[2]) || "flying".equalsIgnoreCase(args[2]) || "flight".equalsIgnoreCase(args[2]) || "flug".equalsIgnoreCase(args[2]) || "fliegen".equalsIgnoreCase(args[2]))) {
                    cs.sendMessage(this.getPrefix() + this.getSyntax("Speed", label, cmd.getName(), cs, null));
                    return true;
                }
                isFly = true;
            }
            try {
                speed = this.getRealMoveSpeed(this.getMoveSpeed(Float.parseFloat(args[0])), isFly);
            }
            catch (NumberFormatException ignored) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Speed.NotANumber", label, cmd.getName(), cs, null));
                return true;
            }
        }
        if (speed == -1.0f) {
            cs.sendMessage((Object)((Object)ChatColor.DARK_RED) + "Error!");
            return true;
        }
        if (player != cs) {
            if (!this.isAllowed(cs, "speed.others")) {
                cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("speed.others")));
                return true;
            }
        } else if (!this.isAllowed(cs, "speed.self")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("speed.self")));
            return true;
        }
        this.setMovementSpeed(player, Float.valueOf(speed), isFly, cs, args[0], cmd.getName(), label);
        return true;
    }

    private void setMovementSpeed(Player player, Float speed, boolean isFly, CommandSender cs, String sped, String cmd, String label) {
        if (isFly) {
            player.setFlySpeed(speed.floatValue());
        } else {
            player.setWalkSpeed(speed.floatValue());
        }
        if (cs == player) {
            if (isFly) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Speed.Fly.Self", label, cmd, cs, (CommandSender)player).replace("<SPEED>", sped));
            } else {
                cs.sendMessage(this.getPrefix() + this.getMessage("Speed.Walk.Self", label, cmd, cs, (CommandSender)player).replace("<SPEED>", sped));
            }
        } else if (isFly) {
            cs.sendMessage(this.getPrefix() + this.getMessage("Speed.Fly.Others.Sender", label, cmd, cs, (CommandSender)player).replace("<SPEED>", sped));
            player.sendMessage(this.getPrefix() + this.getMessage("Speed.Fly.Others.Target", label, cmd, cs, (CommandSender)player).replace("<SPEED>", sped));
        } else {
            cs.sendMessage(this.getPrefix() + this.getMessage("Speed.Walk.Others.Sender", label, cmd, cs, (CommandSender)player).replace("<SPEED>", sped));
            player.sendMessage(this.getPrefix() + this.getMessage("Speed.Walk.Others.Target", label, cmd, cs, (CommandSender)player).replace("<SPEED>", sped));
        }
    }

    private float getMoveSpeed(float userSpeed) {
        if (userSpeed > 10.0f) {
            userSpeed = 10.0f;
        } else if (userSpeed < 1.0E-4f) {
            userSpeed = 1.0E-4f;
        }
        return userSpeed;
    }

    private float getRealMoveSpeed(float userSpeed, boolean isFly) {
        float defaultSpeed = isFly ? 0.1f : 0.2f;
        float maxSpeed = 1.0f;
        if (userSpeed < 1.0f) {
            return defaultSpeed * userSpeed;
        }
        float ratio = (userSpeed - 1.0f) / 9.0f * (maxSpeed - defaultSpeed);
        return ratio + defaultSpeed;
    }
}

