/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import java.io.File;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.ChatColor;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpawnCommand
extends MessageUtils
implements CommandExecutor {
    public SpawnCommand(ServerSystem plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        if (!(cs instanceof Player)) {
            cs.sendMessage(this.getPrefix() + this.getOnlyPlayer());
            return true;
        }
        if (this.plugin.getPermissions().getCfg().getBoolean("Permissions.spawn.required") && !this.isAllowed(cs, "spawn.permission")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("spawn.permission")));
            return true;
        }
        File spawnFile = new File("plugins//ServerSystem", "spawn.yml");
        if (!spawnFile.exists()) {
            cs.sendMessage(this.getPrefix() + this.getMessage("Spawn.NoSpawn", label, cmd.getName(), cs, null));
            return true;
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)spawnFile);
        Location location = ((Player)cs).getLocation().clone();
        location.setX(cfg.getDouble("Spawn.X"));
        location.setY(cfg.getDouble("Spawn.Y"));
        location.setZ(cfg.getDouble("Spawn.Z"));
        location.setYaw((float)cfg.getDouble("Spawn.Yaw"));
        location.setPitch((float)cfg.getDouble("Spawn.Pitch"));
        location.setWorld(Bukkit.getWorld((String)cfg.getString("Spawn.World")));
        if (!this.plugin.getConfigReader().getBoolean("teleportation.spawn.enabledelay") || this.isAllowed(cs, "spawn.bypassdelay", true)) {
            ((Player)cs).teleport(location);
            cs.sendMessage(this.getPrefix() + this.getMessage("Spawn.InstantTeleporting", label, cmd.getName(), cs, null));
            return true;
        }
        this.plugin.getTeleportMap().put((Player)cs, Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player player = ((OfflinePlayer)cs).getPlayer();
            if (player.isOnline()) {
                player.getPlayer().teleport(location);
                cs.sendMessage(this.plugin.getMessages().getPrefix() + ChatColor.translateAlternateColorCodes('&', this.plugin.getMessages().getCfg().getString("Messages.Misc.Teleportation.Success")));
                this.plugin.getTeleportMap().remove(player);
            }
        }, 20L * (long)this.plugin.getConfigReader().getInt("teleportation.spawn.delay")));
        cs.sendMessage(this.plugin.getMessages().getPrefix() + this.plugin.getMessages().getMessage(label, cmd.getName(), cs, null, "Home.Teleporting"));
        return true;
    }
}

