/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.entity303.serversystem.main.ServerSystem;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SetHomeCommand
implements CommandExecutor {
    private final ServerSystem plugin;

    public SetHomeCommand(ServerSystem plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        if (!(cs instanceof Player)) {
            cs.sendMessage(this.plugin.getMessages().getPrefix() + this.plugin.getMessages().getOnlyPlayer());
            return true;
        }
        if (this.plugin.getPermissions().getCfg().getBoolean("Permissions.sethome.general.required") && !this.plugin.getPermissions().hasPerm(cs, "sethome.general.permission")) {
            cs.sendMessage(this.plugin.getMessages().getPrefix() + this.plugin.getMessages().getNoPermission(this.plugin.getPermissions().Perm("sethome.general.permission")));
            return true;
        }
        if (args.length <= 0) {
            cs.sendMessage(this.plugin.getMessages().getPrefix() + this.plugin.getMessages().getSyntax(label, cmd.getName(), cs, null, "SetHome"));
            return true;
        }
        File homeFile = new File("plugins//ServerSystem//Homes", ((Player)cs).getUniqueId() + ".yml");
        YamlConfiguration homeCfg = YamlConfiguration.loadConfiguration((File)homeFile);
        ArrayList homes = new ArrayList();
        if (homeFile.exists() && homeCfg.getConfigurationSection("Homes") != null) {
            homes.addAll(homeCfg.getConfigurationSection("Homes").getKeys(false));
        }
        if (!this.allowMoreHomes((Player)cs, homes.size())) {
            cs.sendMessage(this.plugin.getMessages().getPrefix() + this.plugin.getMessages().getMessage(label, cmd.getName(), cs, null, "SetHome.MaxReached"));
            return true;
        }
        homeCfg.set("Homes." + args[0].toUpperCase(), (Object)((Player)cs).getLocation());
        cs.sendMessage(this.plugin.getMessages().getPrefix() + this.plugin.getMessages().getMessage(label, cmd.getName(), cs, null, "SetHome.Success").replace("<HOME>", args[0].toUpperCase()));
        try {
            homeCfg.save(homeFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean allowMoreHomes(Player player, Integer homes) {
        if (this.plugin.getPermissions().hasPerm((CommandSender)player, "sethome.bypassmax", true)) {
            return true;
        }
        String permissions2 = null;
        for (String amount : this.plugin.getPermissions().getCfg().getConfigurationSection("Permissions.sethome.maxhomes").getKeys(false)) {
            if (amount.equalsIgnoreCase("default") || Integer.parseInt(amount) <= homes) continue;
            permissions2 = this.plugin.getPermissions().getCfg().getString("Permissions.sethome.maxhomes." + amount);
            if (permissions2 == null) {
                this.plugin.error("Sethome Permission " + amount + " cannot be null!");
                continue;
            }
            if (!player.hasPermission(permissions2)) continue;
            return true;
        }
        return false;
    }
}

