/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class RecipeCommand
extends MessageUtils
implements CommandExecutor {
    private static final List<Player> recipeList = new ArrayList<Player>();

    public RecipeCommand(ServerSystem plugin) {
        super(plugin);
    }

    public static List<Player> getRecipeList() {
        return recipeList;
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        List recipeList;
        Material material;
        if (this.plugin.getPermissions().getCfg().getBoolean("Permissions.recipe.required") && !this.isAllowed(cs, "recipe.permission")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("recipe.permission")));
            return true;
        }
        if (!(cs instanceof Player)) {
            cs.sendMessage(this.getPrefix() + this.getOnlyPlayer());
            return true;
        }
        Player player = (Player)cs;
        if (args.length <= 0) {
            ItemStack stack = player.getInventory().getItemInHand();
            if (stack.getType() == Material.AIR) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Recipe.NoItem", label, cmd.getName(), cs, null));
                return true;
            }
            List recipeList2 = Bukkit.getRecipesFor((ItemStack)stack);
            if (recipeList2.isEmpty()) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Recipe.NoRecipe", label, cmd.getName(), cs, null).replace("<MATERIAL>", stack.getType().name()));
                return true;
            }
            RecipeCommand.recipeList.add((Player)cs);
            Recipe recipe = (Recipe)recipeList2.get(0);
            if (recipe instanceof ShapelessRecipe) {
                int i;
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                InventoryView inventoryView = player.openWorkbench(player.getLocation(), true);
                Inventory craftingInventory = inventoryView.getTopInventory();
                ItemStack[] contents = new ItemStack[10];
                for (i = 0; i < 10; ++i) {
                    contents[i] = null;
                }
                i = 1;
                int i1 = 0;
                while (i < Math.min(shapelessRecipe.getIngredientList().size() + 1, 11)) {
                    contents[i] = this.normalize((ItemStack)shapelessRecipe.getIngredientList().get(i1));
                    ++i;
                    ++i1;
                }
                craftingInventory.setContents(contents);
                return true;
            }
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                InventoryView inventoryView = player.openWorkbench(player.getLocation(), true);
                Inventory craftingInventory = inventoryView.getTopInventory();
                ItemStack[] contents = new ItemStack[10];
                for (int i = 0; i < 10; ++i) {
                    contents[i] = null;
                }
                LinkedHashMap<Character, ItemStack> ingredient = new LinkedHashMap<Character, ItemStack>();
                String[] rows = shapedRecipe.getShape();
                ArrayList<String> alphabet = new ArrayList<String>(Arrays.asList("abcdefghijklmnopqrstuvwxyz".split("")));
                for (String row : rows) {
                    for (String character : row.split("")) {
                        alphabet.remove(character);
                    }
                }
                for (String row : rows) {
                    StringBuilder rowEdit = new StringBuilder(row);
                    int rowLength = row.split("").length;
                    for (String character : row.split("")) {
                        if (character.equalsIgnoreCase(" ")) {
                            ingredient.put(Character.valueOf(character.charAt(0)), null);
                            continue;
                        }
                        ingredient.put(Character.valueOf(character.charAt(0)), (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(character.charAt(0))));
                    }
                    String usedCharacter = "";
                    block9: for (int i = rowLength; i < 3; ++i) {
                        for (String character : alphabet) {
                            if (rowEdit.toString().contains(character)) continue;
                            rowEdit.append(character);
                            ingredient.put(Character.valueOf(character.charAt(0)), null);
                            usedCharacter = character;
                            continue block9;
                        }
                    }
                    for (String character : usedCharacter.split("")) {
                        alphabet.remove(character);
                    }
                }
                int i = 1;
                for (ItemStack itemStack : ingredient.values()) {
                    if (i >= 10) break;
                    contents[i] = this.normalize(itemStack);
                    ++i;
                }
                craftingInventory.setContents(contents);
                return true;
            }
            cs.sendMessage(this.getPrefix() + this.getMessage("Recipe.NoRecipe", label, cmd.getName(), cs, null).replace("<MATERIAL>", stack.getType().name()));
            return true;
        }
        String name = args[0].toUpperCase().split(":")[0];
        int subId = 0;
        if (name.contains(":")) {
            try {
                subId = Integer.parseInt(args[0].split(":")[1]);
            }
            catch (Exception recipe) {
                // empty catch block
            }
        }
        if ((material = Material.getMaterial((String)name)) == null) {
            cs.sendMessage(this.getPrefix() + this.getMessage("Recipe.InvalidMaterial", label, cmd.getName(), cs, null).replace("<MATERIAL>", name));
            return true;
        }
        ItemStack stack = new ItemStack(material);
        if (stack.getType() == Material.AIR) {
            cs.sendMessage(this.getPrefix() + this.getMessage("Recipe.InvalidMaterial", label, cmd.getName(), cs, null).replace("<MATERIAL>", name));
            return true;
        }
        if (!this.plugin.getVersionManager().isV119()) {
            stack.setDurability((short)subId);
        }
        if ((recipeList = Bukkit.getRecipesFor((ItemStack)stack)).isEmpty()) {
            cs.sendMessage(this.getPrefix() + this.getMessage("Recipe.NoRecipe", label, cmd.getName(), cs, null).replace("<MATERIAL>", name));
            return true;
        }
        RecipeCommand.recipeList.add((Player)cs);
        Recipe recipe = (Recipe)recipeList.get(0);
        if (recipe instanceof ShapelessRecipe) {
            int i;
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            InventoryView inventoryView = player.openWorkbench(player.getLocation(), true);
            Inventory craftingInventory = inventoryView.getTopInventory();
            ItemStack[] contents = new ItemStack[10];
            for (i = 0; i < 10; ++i) {
                contents[i] = null;
            }
            i = 1;
            int i1 = 0;
            while (i < Math.min(shapelessRecipe.getIngredientList().size() + 1, 11)) {
                contents[i] = this.normalize((ItemStack)shapelessRecipe.getIngredientList().get(i1));
                ++i;
                ++i1;
            }
            craftingInventory.setContents(contents);
            return true;
        }
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            InventoryView inventoryView = player.openWorkbench(player.getLocation(), true);
            Inventory craftingInventory = inventoryView.getTopInventory();
            ItemStack[] contents = new ItemStack[10];
            for (int i = 0; i < 10; ++i) {
                contents[i] = null;
            }
            LinkedHashMap<Character, ItemStack> ingredient = new LinkedHashMap<Character, ItemStack>();
            String[] rows = shapedRecipe.getShape();
            ArrayList<String> alphabet = new ArrayList<String>(Arrays.asList("abcdefghijklmnopqrstuvwxyz".split("")));
            for (String row : rows) {
                for (String character : row.split("")) {
                    alphabet.remove(character);
                }
            }
            for (String row : rows) {
                StringBuilder rowEdit = new StringBuilder(row);
                int rowLength = row.split("").length;
                for (String character : row.split("")) {
                    if (character.equalsIgnoreCase(" ")) {
                        ingredient.put(Character.valueOf(character.charAt(0)), null);
                        continue;
                    }
                    ingredient.put(Character.valueOf(character.charAt(0)), (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(character.charAt(0))));
                }
                String usedCharacter = "";
                block20: for (int i = rowLength; i < 3; ++i) {
                    for (String character : alphabet) {
                        if (rowEdit.toString().contains(character)) continue;
                        rowEdit.append(character);
                        ingredient.put(Character.valueOf(character.charAt(0)), null);
                        usedCharacter = character;
                        continue block20;
                    }
                }
                for (String character : usedCharacter.split("")) {
                    alphabet.remove(character);
                }
            }
            int i = 1;
            for (ItemStack itemStack : ingredient.values()) {
                if (i >= 10) break;
                contents[i] = this.normalize(itemStack);
                ++i;
            }
            craftingInventory.setContents(contents);
            return true;
        }
        cs.sendMessage(this.getPrefix() + this.getMessage("Recipe.NoRecipe", label, cmd.getName(), cs, null).replace("<MATERIAL>", name));
        return true;
    }

    private ItemStack normalize(ItemStack itemStack) {
        if (this.plugin.getVersionManager().isV119()) {
            return itemStack;
        }
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getDurability() > 15) {
            itemStack.setDurability((short)0);
        }
        return itemStack;
    }
}

