/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import me.entity303.serversystem.bansystem.Mute;
import me.entity303.serversystem.bansystem.TimeUnit;
import me.entity303.serversystem.events.AsyncMuteEvent;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class MuteCommand
extends MessageUtils
implements CommandExecutor {
    public MuteCommand(ServerSystem plugin) {
        super(plugin);
    }

    private static OfflinePlayer getPlayer(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            player = Bukkit.getOfflinePlayer((String)name);
        }
        return player;
    }

    private ServerSystem getPlugin() {
        return this.plugin;
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        long time;
        String sender;
        if (this.getPlugin().getMuteManager() == null) {
            this.plugin.error("BanManager is null?!");
            return true;
        }
        String string = sender = cs instanceof Player ? ((Player)cs).getUniqueId().toString() : this.getBanSystem("ConsoleName");
        if (!this.isAllowed(cs, "mute.use")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("mute.use")));
            return true;
        }
        if (args.length <= 1) {
            cs.sendMessage(this.getPrefix() + this.getSyntaxWithStringTarget("Mute", label, cmd.getName(), cs, args.length >= 1 ? args[0] : null).replace("<YEAR>", TimeUnit.getName(TimeUnit.YEAR)).replace("<MONTH>", TimeUnit.getName(TimeUnit.MONTH)).replace("<WEEK>", TimeUnit.getName(TimeUnit.WEEK)).replace("<DAY>", TimeUnit.getName(TimeUnit.DAY)).replace("<HOUR>", TimeUnit.getName(TimeUnit.HOUR)).replace("<MINUTE>", TimeUnit.getName(TimeUnit.MINUTE)).replace("<SECOND>", TimeUnit.getName(TimeUnit.SECOND)));
            return true;
        }
        OfflinePlayer target = MuteCommand.getPlayer(args[0]);
        if (args.length == 2) {
            if (args[1].equalsIgnoreCase(this.getBanSystem("PermanentName"))) {
                if (!this.isAllowed(cs, "mute.permanent")) {
                    cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("mute.permanent")));
                    return true;
                }
                if (target.isOnline() && this.isAllowed((CommandSender)target.getPlayer(), "mute.exempt", true)) {
                    cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.CannotMute", label, cmd.getName(), cs, target.getName()));
                    return true;
                }
                String reason = this.getMessageWithStringTarget("Mute.DefaultReason", label, cmd.getName(), cs, target.getName());
                long time2 = -1L;
                Mute mute = this.getPlugin().getMuteManager().addMute(target.getUniqueId(), sender, reason, time2, TimeUnit.YEAR);
                if (cs instanceof Player) {
                    this.plugin.getMuteManager().removeMute(((Player)cs).getUniqueId());
                }
                cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.Success", label, cmd.getName(), cs, target.getName()).replace("<REASON>", reason).replace("<UNMUTE_DATE>", mute.getUNMUTE_DATE()));
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    AsyncMuteEvent asyncMuteEvent = new AsyncMuteEvent(cs, target, reason, mute.getUNMUTE_DATE());
                    Bukkit.getPluginManager().callEvent((Event)asyncMuteEvent);
                });
                return true;
            }
            cs.sendMessage(this.getPrefix() + this.getSyntaxWithStringTarget("Mute", label, cmd.getName(), cs, args[0]).replace("<YEAR>", TimeUnit.getName(TimeUnit.YEAR)).replace("<MONTH>", TimeUnit.getName(TimeUnit.MONTH)).replace("<WEEK>", TimeUnit.getName(TimeUnit.WEEK)).replace("<DAY>", TimeUnit.getName(TimeUnit.DAY)).replace("<HOUR>", TimeUnit.getName(TimeUnit.HOUR)).replace("<MINUTE>", TimeUnit.getName(TimeUnit.MINUTE)).replace("<SECOND>", TimeUnit.getName(TimeUnit.SECOND)));
            return true;
        }
        if (args[1].equalsIgnoreCase(this.getBanSystem("PermanentName"))) {
            if (!this.isAllowed(cs, "mute.permanent")) {
                cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("mute.permanent")));
                return true;
            }
            if (target.isOnline() && this.isAllowed((CommandSender)target.getPlayer(), "mute.exempt", true)) {
                cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.CannotMute", label, cmd.getName(), cs, target.getName()));
                return true;
            }
            String reason = this.getMessageWithStringTarget("Mute.DefaultReason", label, cmd.getName(), cs, target.getName());
            boolean shadow = false;
            if (args.length > 3) {
                String s;
                StringBuilder sb;
                if (args[2].equalsIgnoreCase(this.getBanSystem("ShadowBan")) && this.isAllowed(cs, "mute.shadow.permanent", true)) {
                    shadow = true;
                    sb = new StringBuilder();
                    for (int i = 3; i < args.length; ++i) {
                        s = i == args.length - 1 ? args[i] : args[i] + " ";
                        sb.append(s);
                    }
                    reason = sb.toString();
                } else {
                    sb = new StringBuilder();
                    for (int i = 2; i < args.length; ++i) {
                        s = i == args.length - 1 ? args[i] : args[i] + " ";
                        sb.append(s);
                    }
                    reason = sb.toString();
                }
            }
            if (reason.equalsIgnoreCase("")) {
                reason = this.getMessageWithStringTarget("Mute.DefaultReason", label, cmd.getName(), cs, target.getName());
            }
            long time3 = -1L;
            Mute mute = shadow ? this.getPlugin().getMuteManager().addMute(target.getUniqueId(), sender, reason, true, time3, TimeUnit.YEAR) : this.getPlugin().getMuteManager().addMute(target.getUniqueId(), sender, reason, time3, TimeUnit.YEAR);
            if (cs instanceof Player) {
                this.plugin.getMuteManager().removeMute(((Player)cs).getUniqueId());
            }
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.Success", label, cmd.getName(), cs, target.getName()).replace("<REASON>", reason).replace("<UNMUTE_DATE>", mute.getUNMUTE_DATE()));
            String finalReason = reason;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                AsyncMuteEvent asyncMuteEvent = new AsyncMuteEvent(cs, target, finalReason, mute.getUNMUTE_DATE());
                Bukkit.getPluginManager().callEvent((Event)asyncMuteEvent);
            });
            return true;
        }
        if (!this.isAllowed(cs, "mute.temporary")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("mute.temporary")));
            return true;
        }
        if (target.isOnline() && this.isAllowed((CommandSender)target.getPlayer(), "mute.exempt", true)) {
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.CannotMute", label, cmd.getName(), cs, target.getName()));
            return true;
        }
        try {
            time = Long.parseLong(args[1]);
        }
        catch (NumberFormatException ignored) {
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.NotANumber", label, cmd.getName(), cs, target.getName()).replace("<TIME>", args[1]));
            return true;
        }
        TimeUnit timeUnit = TimeUnit.getFromName(args[2]);
        if (timeUnit == null) {
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.NotATimeUnit", label, cmd.getName(), cs, target.getName()).replace("<TIMEUNIT>", args[2]));
            return true;
        }
        String reason = this.getMessageWithStringTarget("Mute.DefaultReason", label, cmd.getName(), cs, target.getName());
        boolean shadow = false;
        if (args.length > 3) {
            int i;
            StringBuilder sb;
            if (args[3].equalsIgnoreCase(this.getBanSystem("ShadowBan")) && this.isAllowed(cs, "mute.shadow.permanent", true)) {
                shadow = true;
                sb = new StringBuilder();
                for (i = 4; i < args.length; ++i) {
                    String s = i == args.length - 1 ? args[i] : args[i] + " ";
                    sb.append(s);
                }
                reason = sb.toString();
            } else {
                sb = new StringBuilder();
                for (i = 3; i < args.length; ++i) {
                    String s = i == args.length - 1 ? args[i] : args[i] + " ";
                    sb.append(s);
                }
                reason = sb.toString();
            }
        }
        if (reason.equalsIgnoreCase("")) {
            reason = this.getMessageWithStringTarget("Mute.DefaultReason", label, cmd.getName(), cs, target.getName());
        }
        Mute mute = shadow ? this.plugin.getMuteManager().addMute(target.getUniqueId(), sender, reason, true, time, timeUnit) : this.plugin.getMuteManager().addMute(target.getUniqueId(), sender, reason, time, timeUnit);
        if (cs instanceof Player) {
            this.plugin.getMuteManager().removeMute(((Player)cs).getUniqueId());
        }
        cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Mute.Success", label, cmd.getName(), cs, target.getName()).replace("<REASON>", reason).replace("<UNMUTE_DATE>", mute.getUNMUTE_DATE()));
        String finalReason = reason;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            AsyncMuteEvent asyncMuteEvent = new AsyncMuteEvent(cs, target, finalReason, mute.getUNMUTE_DATE());
            Bukkit.getPluginManager().callEvent((Event)asyncMuteEvent);
        });
        return true;
    }
}

