/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KitCommand
extends MessageUtils
implements CommandExecutor {
    public KitCommand(ServerSystem plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            cs.sendMessage(this.getPrefix() + this.getSyntax("Kit", label, cmd.getName(), cs, null));
            return true;
        }
        if (args.length == 1) {
            if (!(cs instanceof Player)) {
                cs.sendMessage(this.getPrefix() + this.getSyntax("Kit", label, cmd.getName(), cs, null));
                return true;
            }
            if (!this.plugin.getKitsManager().doesKitExist(args[0])) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Kit.DoesntExist", label, cmd.getName(), cs, null).replace("<KIT>", args[0].toUpperCase()));
                return true;
            }
            if (!this.plugin.getKitsManager().isKitAllowed(cs, args[0], false)) {
                cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("kit.self").replace("<KIT>", args[0].toLowerCase())));
                return true;
            }
            if (this.plugin.getKitsManager().isKitDelayed((Player)cs, args[0]) && !this.isAllowed(cs, "kit.bypassdelay", true)) {
                String message = this.getMessage("Kit.OnDelay", label, cmd.getName(), cs, null).replace("<KIT>", args[0].toUpperCase());
                long delay = this.plugin.getKitsManager().getPlayerLastDelay(((Player)cs).getUniqueId().toString(), args[0]) + this.plugin.getKitsManager().getKitDelay(args[0]);
                if (message.contains("<MINUTES>")) {
                    this.plugin.log("Found <MINUTES> tag in kit OnDelay message, this outdated, please go with the new <DATE> format!");
                    long calc = delay - System.currentTimeMillis();
                    double minutes = (double)calc / 1000.0 / 60.0;
                    cs.sendMessage(this.getPrefix() + this.getMessage("Kit.OnDelay", label, cmd.getName(), cs, null).replace("<KIT>", args[0].toUpperCase()).replace("<MINUTES>", new DecimalFormat("#.##").format(minutes)));
                    return true;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.getMessage("Kit.TimeFormat", label, cmd.getName(), cs, null));
                Date date = new Date(delay);
                cs.sendMessage(this.getPrefix() + this.getMessage("Kit.OnDelay", label, cmd.getName(), cs, null).replace("<KIT>", args[0].toUpperCase()).replace("<DATE>", dateFormat.format(date)));
                return true;
            }
            this.plugin.getKitsManager().setDelay(((Player)cs).getUniqueId().toString(), args[0], System.currentTimeMillis());
            this.plugin.getKitsManager().giveKit((Player)cs, args[0]);
            cs.sendMessage(this.getPrefix() + this.getMessage("Kit.Success.Self", label, cmd.getName(), cs, null).replace("<KIT>", args[0].toUpperCase()));
            return true;
        }
        String kitName = args[0];
        Player target = this.getPlayer(cs, args[1]);
        if (target == null) {
            cs.sendMessage(this.getPrefix() + this.getNoTarget(args[1]));
            return true;
        }
        if (!this.plugin.getKitsManager().doesKitExist(kitName)) {
            cs.sendMessage(this.getPrefix() + this.getMessage("Kit.DoesntExist", label, cmd.getName(), cs, (CommandSender)target).replace("<KIT>", kitName.toUpperCase()));
            return true;
        }
        if (!this.plugin.getKitsManager().isKitAllowed(cs, kitName, true)) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm(this.Perm("kit.others").replace("<KIT>", kitName.toLowerCase()))));
            return true;
        }
        this.plugin.getKitsManager().giveKit(target, kitName);
        cs.sendMessage(this.getPrefix() + this.getMessage("Kit.Success.Others.Sender", label, cmd.getName(), cs, (CommandSender)target).replace("<KIT>", kitName.toUpperCase()));
        target.sendMessage(this.getPrefix() + this.getMessage("Kit.Success.Others.Target", label, cmd.getName(), cs, (CommandSender)target).replace("<KIT>", kitName.toUpperCase()));
        return true;
    }
}

