/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Warps;
import com.earth2me.essentials.commands.WarpNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.MessageUtils;
import net.ess3.api.InvalidWorldException;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class EssentialsConversionCommand
extends MessageUtils
implements CommandExecutor {
    private boolean starting = false;

    public EssentialsConversionCommand(ServerSystem plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        Warps warps;
        if (!this.isAllowed(cs, "convertfromessentials")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("convertfromessentials")));
            return true;
        }
        if (!this.starting) {
            cs.sendMessage(this.getPrefix() + this.getMessage("ConvertFromEssentials.WarnNotTested", label, cmd.getName(), cs, null));
            this.starting = true;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.starting = false;
            }, 200L);
            return true;
        }
        cs.sendMessage(this.getPrefix() + this.getMessage("ConvertFromEssentials.Start", label, cmd.getName(), cs, null));
        File essentialsDirectory = new File("plugins//Essentials");
        if (!essentialsDirectory.exists()) {
            cs.sendMessage(this.getPrefix() + this.getMessage("ConvertFromEssentials.Failed.NoDirectory", label, cmd.getName(), cs, null));
            return true;
        }
        Essentials essentials = (Essentials)Bukkit.getServer().getPluginManager().getPlugin("Essentials");
        File userDirectory = new File("plugins//Essentials//userdata");
        if (userDirectory.exists()) {
            for (File userData : userDirectory.listFiles()) {
                try {
                    User offlineUser = essentials.getUser(UUID.fromString(userData.getName().split("\\.")[0]));
                    if (offlineUser == null) {
                        this.plugin.error("User '" + userData.getName().split("\\.")[0] + "' is null?!");
                        continue;
                    }
                    this.plugin.getEconomyManager().setMoney(offlineUser.getBase(), offlineUser.getMoney().doubleValue());
                    File homeFile = new File("plugins//ServerSystem//Homes", offlineUser.getConfigUUID().toString() + ".yml");
                    YamlConfiguration homeCfg = YamlConfiguration.loadConfiguration((File)homeFile);
                    boolean setHomes = false;
                    for (String home : offlineUser.getHomes()) {
                        try {
                            setHomes = true;
                            homeCfg.set("Homes." + home.toUpperCase(), (Object)offlineUser.getHome(home));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("ConvertFromEssentials.Failed.Unknown", label, cmd.getName(), cs, "homeSetting;" + offlineUser.getName()) + ";" + home);
                            return true;
                        }
                    }
                    if (setHomes) {
                        try {
                            homeCfg.save(homeFile);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("ConvertFromEssentials.Failed.Unknown", label, cmd.getName(), cs, "homeSaving;" + userData.getName()));
                            return true;
                        }
                    }
                    this.plugin.getVanish().setVanish((Boolean)offlineUser.isVanished(), offlineUser.getConfigUUID());
                }
                catch (Exception e) {
                    this.plugin.error("Failed to process userdata '" + userData.getName() + "'!");
                }
            }
        }
        if ((warps = essentials.getWarps()) != null && !warps.isEmpty()) {
            for (String warp : warps.getList()) {
                try {
                    this.plugin.getWarpManager().addWarp(warp, warps.getWarp(warp));
                }
                catch (WarpNotFoundException | InvalidWorldException e) {
                    e.printStackTrace();
                    cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("ConvertFromEssentials.Failed.Unknown", label, cmd.getName(), cs, "warpSetting;" + warp));
                    return true;
                }
            }
        }
        if (this.plugin != null && this.plugin.getVaultHookManager() != null) {
            this.plugin.getVaultHookManager().hook(true);
        }
        cs.sendMessage(this.getPrefix() + this.getMessage("ConvertFromEssentials.Finished", label, cmd.getName(), cs, null));
        return true;
    }
}

