/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import com.github.intellectualsites.plotsquared.plot.object.Location;
import com.intellectualcrafters.plot.api.PlotAPI;
import com.plotsquared.core.plot.Plot;
import java.lang.reflect.Method;
import me.entity303.serversystem.main.ServerSystem;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditSignPlotSquaredCommand
implements CommandExecutor {
    private final ServerSystem plugin;

    public EditSignPlotSquaredCommand(ServerSystem plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.getVersionStuff().getSignEdit() == null) {
            sender.sendMessage(this.getPrefix() + this.getMessage("EditSign.NotAvailable", label, cmd.getName(), sender, null));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getPrefix() + this.plugin.getMessages().getOnlyPlayer());
            return true;
        }
        Player p = (Player)sender;
        if (this.isLatestPlotSquared()) {
            if (!this.isAllowed((CommandSender)p, "editschild.players")) {
                p.sendMessage(this.getPrefix() + this.plugin.getMessages().getNoPermission(this.plugin.getPermissions().Perm("editschild.players")));
                return true;
            }
            Block block = p.getTargetBlock(null, 5);
            if (block.getState() instanceof Sign) {
                if (!this.isPlotWorldLatest(p)) {
                    Sign sign = (Sign)block.getState();
                    this.plugin.getVersionStuff().getSignEdit().editSign(p, sign);
                    return true;
                }
                if (this.isPlayerInPlotLatest(p) || this.isAllowed((CommandSender)p, "editschild.admin")) {
                    if (this.isPlayerInPlotLatest(p) && this.getLatestPlot(p.getLocation()).isOwner(p.getUniqueId()) || this.isAllowed((CommandSender)p, "editschild.admin")) {
                        Sign sign = (Sign)block.getState();
                        this.plugin.getVersionStuff().getSignEdit().editSign(p, sign);
                    } else {
                        p.sendMessage(this.getPrefix() + this.getMessage("EditSign.NotYourPlot", label, cmd.getName(), sender, null));
                    }
                } else {
                    p.sendMessage(this.getPrefix() + this.getMessage("EditSign.NotInPlot", label, cmd.getName(), sender, null));
                }
            } else {
                p.sendMessage(this.getPrefix() + this.getMessage("EditSign.SignNeeded", label, cmd.getName(), sender, null));
            }
        } else if (this.newerPlotSquared()) {
            if (!this.isAllowed((CommandSender)p, "editschild.players")) {
                p.sendMessage(this.getPrefix() + this.plugin.getMessages().getNoPermission(this.plugin.getPermissions().Perm("editschild.players")));
                return true;
            }
            Block block = p.getTargetBlock(null, 5);
            if (block.getState() instanceof Sign) {
                if (!this.isPlotWorld(p)) {
                    Sign sign = (Sign)block.getState();
                    this.plugin.getVersionStuff().getSignEdit().editSign(p, sign);
                    return true;
                }
                if (this.isPlayerInPlot(p) || this.isAllowed((CommandSender)p, "editschild.admin")) {
                    if (this.isPlayerInPlot(p) && this.getPlot(p.getLocation()).isOwner(p.getUniqueId()) || this.isAllowed((CommandSender)p, "editschild.admin")) {
                        Sign sign = (Sign)block.getState();
                        this.plugin.getVersionStuff().getSignEdit().editSign(p, sign);
                    } else {
                        p.sendMessage(this.getPrefix() + this.getMessage("EditSign.NotYourPlot", label, cmd.getName(), sender, null));
                    }
                } else {
                    p.sendMessage(this.getPrefix() + this.getMessage("EditSign.NotInPlot", label, cmd.getName(), sender, null));
                }
            } else {
                p.sendMessage(this.getPrefix() + this.getMessage("EditSign.SignNeeded", label, cmd.getName(), sender, null));
            }
        } else {
            PlotAPI papi = new PlotAPI();
            if (!this.isAllowed((CommandSender)p, "editschild.players")) {
                p.sendMessage(this.getPrefix() + this.plugin.getMessages().getNoPermission(this.plugin.getPermissions().Perm("editschild.players")));
                return true;
            }
            Block block = p.getTargetBlock(null, 5);
            if (block.getState() instanceof Sign) {
                if (!papi.isPlotWorld(p.getWorld())) {
                    Sign sign = (Sign)block.getState();
                    this.plugin.getVersionStuff().getSignEdit().editSign(p, sign);
                    return true;
                }
                if (papi.getPlot(p.getTargetBlock(null, 5).getLocation()) != null || this.isAllowed((CommandSender)p, "editschild.admin")) {
                    if (papi.isInPlot(p) && papi.getPlot(p.getLocation()).isOwner(p.getUniqueId()) || this.isAllowed((CommandSender)p, "editschild.admin")) {
                        Sign sign = (Sign)block.getState();
                        this.plugin.getVersionStuff().getSignEdit().editSign(p, sign);
                    } else {
                        p.sendMessage(this.getPrefix() + this.getMessage("EditSign.NotYourPlot", label, cmd.getName(), sender, null));
                    }
                } else {
                    p.sendMessage(this.getPrefix() + this.getMessage("EditSign.NotInPlot", label, cmd.getName(), sender, null));
                }
            } else {
                p.sendMessage(this.getPrefix() + this.getMessage("EditSign.SignNeeded", label, cmd.getName(), sender, null));
            }
        }
        return true;
    }

    public Plot getLatestPlot(org.bukkit.Location location) {
        try {
            Method getLocationMethod = Class.forName("com.plotsquared.bukkit.util.BukkitUtil").getDeclaredMethod("getLocation", org.bukkit.Location.class);
            getLocationMethod.setAccessible(true);
            Object plotLocation = getLocationMethod.invoke(null, location);
            Method getPlotMethod = plotLocation.getClass().getDeclaredMethod("getPlot", new Class[0]);
            Object plot = getPlotMethod.invoke(plotLocation, new Object[0]);
            return (Plot)plot;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isPlotWorldLatest(Player player) {
        try {
            Method getLocationMethod = Class.forName("com.plotsquared.bukkit.util.BukkitUtil").getDeclaredMethod("getLocation", org.bukkit.Location.class);
            getLocationMethod.setAccessible(true);
            Object plotLocation = getLocationMethod.invoke(null, player.getLocation());
            Method getPlotAreaMethod = plotLocation.getClass().getDeclaredMethod("getPlotArea", new Class[0]);
            Object plotArea = getPlotAreaMethod.invoke(plotLocation, new Object[0]);
            return plotArea != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPlotWorld(Player player) {
        try {
            org.bukkit.Location location = player.getLocation();
            Location plotLocation = new Location(location.getWorld().getName(), (int)location.getX(), (int)location.getY(), (int)location.getZ());
            if (plotLocation.getPlotArea().getPlots().size() >= 1) {
                return true;
            }
        }
        catch (Exception ignored) {
            return false;
        }
        return false;
    }

    public boolean isLatestPlotSquared() {
        try {
            Class.forName("com.plotsquared.bukkit.listener.PlayerEventListener");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean newerPlotSquared() {
        try {
            Class.forName("com.intellectualcrafters.plot.api.PlotAPI");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return false;
    }

    public com.github.intellectualsites.plotsquared.plot.object.Plot getPlot(org.bukkit.Location location) {
        Location plotLocation = new Location(location.getWorld().getName(), (int)location.getX(), (int)location.getY(), (int)location.getZ());
        return plotLocation.getPlot();
    }

    public boolean isPlayerInPlotLatest(Player player) {
        return this.getLatestPlot(player.getLocation()) != null;
    }

    public boolean isPlayerInPlot(Player player) {
        return this.getPlot(player.getLocation()) != null;
    }

    public String getPrefix() {
        return this.plugin.getMessages().getPrefix();
    }

    public String getMessage(String action, String label, String command, CommandSender sender, CommandSender target) {
        return this.plugin.getMessages().getMessage(label, command, sender, target, action);
    }

    public boolean isAllowed(CommandSender cs, String action) {
        return this.plugin.getPermissions().hasPerm(cs, action);
    }
}

