/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EconomyCommand
extends MessageUtils
implements CommandExecutor {
    public EconomyCommand(ServerSystem plugin) {
        super(plugin);
    }

    private OfflinePlayer player(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            player = Bukkit.getOfflinePlayer((String)name);
        }
        if (!this.plugin.getEconomyManager().hasAccount((OfflinePlayer)player)) {
            return null;
        }
        return player;
    }

    private ServerSystem getPlugin() {
        return this.plugin;
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        if (!this.isAllowed(cs, "economy.general")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("economy.general")));
            return true;
        }
        if (args.length <= 0) {
            cs.sendMessage(this.getPrefix() + this.getSyntax("Economy.General", label, cmd.getName(), cs, null));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "set": {
                if (this.isAllowed(cs, "economy.set")) break;
                cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("economy.set")));
                return true;
            }
            case "give": 
            case "add": {
                if (this.isAllowed(cs, "economy.give")) break;
                cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("economy.give")));
                return true;
            }
            case "revoke": 
            case "take": {
                if (this.isAllowed(cs, "economy.revoke")) break;
                cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("economy.revoke")));
                return true;
            }
            default: {
                cs.sendMessage(this.getPrefix() + this.getSyntax("Economy.General", label, cmd.getName(), cs, null));
            }
        }
        if (args.length <= 2) {
            switch (args[0].toLowerCase()) {
                case "set": {
                    cs.sendMessage(this.getPrefix() + this.getSyntax("Economy.Set", label, cmd.getName(), cs, null));
                    break;
                }
                case "add": {
                    cs.sendMessage(this.getPrefix() + this.getSyntax("Economy.Give", label, cmd.getName(), cs, null));
                    break;
                }
                case "take": {
                    cs.sendMessage(this.getPrefix() + this.getSyntax("Economy.Revoke", label, cmd.getName(), cs, null));
                    break;
                }
                default: {
                    cs.sendMessage(this.getPrefix() + this.getSyntax("Economy.General", label, cmd.getName(), cs, null));
                }
            }
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "set": {
                double amount;
                OfflinePlayer target = this.player(args[1]);
                if (target == null) {
                    cs.sendMessage(this.getPrefix() + this.getNoTarget(args[1]));
                    return true;
                }
                try {
                    amount = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException ignored) {
                    cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Error.NotANumber", label, cmd.getName(), cs, target.getName()).replace("<NUMBER>", args[2]));
                    return true;
                }
                this.getPlugin().getEconomyManager().setMoney(target, amount);
                cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Success.Set.Sender", label, cmd.getName(), cs, target.getName()).replace("<AMOUNT>", this.getPlugin().getEconomyManager().format(amount)));
                if (!target.isOnline()) break;
                target.getPlayer().sendMessage(this.getPrefix() + this.getMessage("Economy.Success.Set.Target", label, cmd.getName(), cs, (CommandSender)target.getPlayer()).replace("<AMOUNT>", this.getPlugin().getEconomyManager().format(amount)));
                break;
            }
            case "add": {
                double amount;
                OfflinePlayer target = this.player(args[1]);
                if (target == null) {
                    cs.sendMessage(this.getPrefix() + this.getNoTarget(args[1]));
                    return true;
                }
                try {
                    amount = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException ignored) {
                    cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Error.NotANumber", label, cmd.getName(), cs, target.getName()).replace("<NUMBER>", args[2]));
                    return true;
                }
                this.getPlugin().getEconomyManager().addMoney(target, amount);
                cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Success.Give.Sender", label, cmd.getName(), cs, target.getName()).replace("<AMOUNT>", this.getPlugin().getEconomyManager().format(amount)));
                if (!target.isOnline()) break;
                target.getPlayer().sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Success.Give.Target", label, cmd.getName(), cs, target.getName()).replace("<AMOUNT>", this.getPlugin().getEconomyManager().format(amount)));
                break;
            }
            case "take": {
                double amount;
                OfflinePlayer target = this.player(args[1]);
                if (target == null) {
                    cs.sendMessage(this.getPrefix() + this.getNoTarget(args[1]));
                    return true;
                }
                try {
                    amount = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException ignored) {
                    cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Error.NotANumber", label, cmd.getName(), cs, target.getName()).replace("<NUMBER>", args[2]));
                    return true;
                }
                this.getPlugin().getEconomyManager().removeMoney(target, amount);
                cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Success.Revoke.Sender", label, cmd.getName(), cs, target.getName()).replace("<AMOUNT>", this.getPlugin().getEconomyManager().format(amount)));
                if (!target.isOnline()) break;
                target.getPlayer().sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Economy.Success.Revoke.Target", label, cmd.getName(), cs, target.getName()).replace("<AMOUNT>", this.getPlugin().getEconomyManager().format(amount)));
                break;
            }
            default: {
                cs.sendMessage(this.getPrefix() + this.getSyntax("Economy.General", label, cmd.getName(), cs, null));
            }
        }
        return true;
    }
}

