/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.commands.executable;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.entity303.serversystem.bansystem.Ban;
import me.entity303.serversystem.bansystem.TimeUnit;
import me.entity303.serversystem.events.AsyncBanEvent;
import me.entity303.serversystem.main.ServerSystem;
import me.entity303.serversystem.utils.ChatColor;
import me.entity303.serversystem.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class BanCommand
extends MessageUtils
implements CommandExecutor {
    public BanCommand(ServerSystem plugin) {
        super(plugin);
    }

    private static OfflinePlayer getPlayer(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            player = Bukkit.getOfflinePlayer((String)name);
        }
        return player;
    }

    private ServerSystem getPlugin() {
        return this.plugin;
    }

    public boolean onCommand(CommandSender cs, Command cmd, String label, String[] args) {
        TimeUnit timeUnit;
        long time;
        if (this.getPlugin().getBanManager() == null) {
            this.plugin.error("BanManager is null?!");
            return true;
        }
        if (!this.isAllowed(cs, "ban.use.general")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("ban.use.general")));
            return true;
        }
        if (args.length <= 1) {
            cs.sendMessage(this.getPrefix() + this.getSyntaxWithStringTarget("Ban", label, cmd.getName(), cs, args.length >= 1 ? args[0] : null).replace("<YEAR>", TimeUnit.getName(TimeUnit.YEAR)).replace("<MONTH>", TimeUnit.getName(TimeUnit.MONTH)).replace("<WEEK>", TimeUnit.getName(TimeUnit.WEEK)).replace("<DAY>", TimeUnit.getName(TimeUnit.DAY)).replace("<HOUR>", TimeUnit.getName(TimeUnit.HOUR)).replace("<MINUTE>", TimeUnit.getName(TimeUnit.MINUTE)).replace("<SECOND>", TimeUnit.getName(TimeUnit.SECOND)));
            return true;
        }
        if (args.length == 2) {
            if (args[1].equalsIgnoreCase(this.getBanSystem("PermanentName"))) {
                if (!this.isAllowed(cs, "ban.use.permanent")) {
                    cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("ban.use.permanent")));
                    return true;
                }
                OfflinePlayer target = BanCommand.getPlayer(args[0]);
                long time2 = -1L;
                String reason = this.getMessageWithStringTarget("Ban.DefaultReason", label, cmd.getName(), cs, target.getName());
                if (target.isOnline() && this.isAllowed((CommandSender)target.getPlayer(), "ban.exempt", true)) {
                    cs.sendMessage(this.getPrefix() + this.getMessage("Ban.Cannotban", label, cmd.getName(), cs, (CommandSender)target.getPlayer()));
                    return true;
                }
                Ban ban = this.getPlugin().getBanManager().createBan(target.getUniqueId(), cs instanceof Player ? ((Player)cs).getUniqueId().toString() : this.getBanSystem("ConsoleName"), reason, time2, TimeUnit.YEAR);
                cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Ban.Success", label, cmd.getName(), cs, target.getName()).replace("<DATE>", ban.getUNBAN_DATE()));
                if (target.isOnline()) {
                    target.getPlayer().kickPlayer(this.getMessageWithStringTarget("Ban.Kick", label, cmd.getName(), cs, target.getName()).replace("<REASON>", ChatColor.translateAlternateColorCodes('&', ban.getBAN_REASON())).replace("<DATE>", ChatColor.translateAlternateColorCodes('&', ban.getUNBAN_DATE())));
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    AsyncBanEvent asyncBanEvent = new AsyncBanEvent(cs, target, reason, ban.getUNBAN_DATE());
                    Bukkit.getPluginManager().callEvent((Event)asyncBanEvent);
                });
                return true;
            }
            cs.sendMessage(this.getPrefix() + this.getSyntaxWithStringTarget("Ban", label, cmd.getName(), cs, args[0]).replace("<YEAR>", TimeUnit.YEAR.getName()).replace("<MONTH>", TimeUnit.MONTH.getName()).replace("<WEEK>", TimeUnit.WEEK.getName()).replace("<DAY>", TimeUnit.DAY.getName()).replace("<HOUR>", TimeUnit.HOUR.getName()).replace("<MINUTE>", TimeUnit.MINUTE.getName()).replace("<SECOND>", TimeUnit.SECOND.getName()));
            return true;
        }
        if (args[1].equalsIgnoreCase(this.getBanSystem("PermanentName"))) {
            if (!this.isAllowed(cs, "ban.use.permanent")) {
                cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("ban.use.permanent")));
                return true;
            }
            OfflinePlayer target = BanCommand.getPlayer(args[0]);
            long time3 = -1L;
            String reason = "";
            reason = IntStream.range(2, args.length).mapToObj(i -> args[i] + " ").collect(Collectors.joining());
            if (reason.equalsIgnoreCase("")) {
                reason = this.getMessageWithStringTarget("Ban.DefaultReason", label, cmd.getName(), cs, target.getName());
            }
            if (target.isOnline() && this.isAllowed((CommandSender)target.getPlayer(), "ban.exempt", true)) {
                cs.sendMessage(this.getPrefix() + this.getMessage("Ban.Cannotban", label, cmd.getName(), cs, (CommandSender)target.getPlayer()));
                return true;
            }
            Ban ban = this.getPlugin().getBanManager().createBan(target.getUniqueId(), cs instanceof Player ? ((Player)cs).getUniqueId().toString() : this.getBanSystem("ConsoleName"), reason, time3, TimeUnit.YEAR);
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Ban.Success", label, cmd.getName(), cs, target.getName()).replace("<DATE>", ban.getUNBAN_DATE()));
            if (target.isOnline()) {
                target.getPlayer().kickPlayer(this.getMessage("Ban.Kick", label, cmd.getName(), cs, (CommandSender)target.getPlayer()).replace("<REASON>", ChatColor.translateAlternateColorCodes('&', ban.getBAN_REASON())).replace("<DATE>", ChatColor.translateAlternateColorCodes('&', ban.getUNBAN_DATE())));
            }
            String finalReason = reason;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                AsyncBanEvent asyncBanEvent = new AsyncBanEvent(cs, target, finalReason, ban.getUNBAN_DATE());
                Bukkit.getPluginManager().callEvent((Event)asyncBanEvent);
            });
            return true;
        }
        if (!this.isAllowed(cs, "ban.use.temporary")) {
            cs.sendMessage(this.getPrefix() + this.getNoPermission(this.Perm("ban.use.temporary")));
            return true;
        }
        OfflinePlayer target = BanCommand.getPlayer(args[0]);
        try {
            time = Long.parseLong(args[1]);
        }
        catch (NumberFormatException ignored) {
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Ban.NotANumber", label, cmd.getName(), cs, target.getName()).replace("<TIME>", args[1]));
            return true;
        }
        if (time < 1L) {
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Ban.NotANumber", label, cmd.getName(), cs, target.getName()).replace("<TIME>", args[1]));
        }
        if ((timeUnit = TimeUnit.getFromName(args[2])) == null) {
            cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Ban.NotATimeUnit", label, cmd.getName(), cs, target.getName()).replace("<TIMEUNIT>", args[2]));
            return true;
        }
        String reason = this.getMessageWithStringTarget("Ban.DefaultReason", label, cmd.getName(), cs, target.getName());
        reason = IntStream.range(3, args.length).mapToObj(i -> args[i] + " ").collect(Collectors.joining());
        if (reason.equalsIgnoreCase("")) {
            reason = this.getMessageWithStringTarget("Ban.DefaultReason", label, cmd.getName(), cs, target.getName());
        }
        if (target.isOnline() && this.isAllowed((CommandSender)target.getPlayer(), "ban.exempt", true)) {
            cs.sendMessage(this.getPrefix() + this.getMessage("Ban.Cannotban", label, cmd.getName(), cs, (CommandSender)target.getPlayer()));
            return true;
        }
        Ban ban = this.getPlugin().getBanManager().createBan(target.getUniqueId(), cs instanceof Player ? ((Player)cs).getUniqueId().toString() : this.getBanSystem("ConsoleName"), reason, time, timeUnit);
        cs.sendMessage(this.getPrefix() + this.getMessageWithStringTarget("Ban.Success", label, cmd.getName(), cs, target.getName()).replace("<DATE>", ban.getUNBAN_DATE()));
        if (target.isOnline()) {
            target.getPlayer().kickPlayer(this.getMessage("Ban.Kick", label, cmd.getName(), cs, (CommandSender)target.getPlayer()).replace("<REASON>", ChatColor.translateAlternateColorCodes('&', ban.getBAN_REASON())).replace("<DATE>", ChatColor.translateAlternateColorCodes('&', ban.getUNBAN_DATE())));
        }
        String finalReason = reason;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            AsyncBanEvent asyncBanEvent = new AsyncBanEvent(cs, target, finalReason, ban.getUNBAN_DATE());
            Bukkit.getPluginManager().callEvent((Event)asyncBanEvent);
        });
        return true;
    }
}

