/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.bansystem;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.entity303.serversystem.bansystem.ManagerMute;
import me.entity303.serversystem.bansystem.Mute;
import me.entity303.serversystem.bansystem.TimeUnit;
import me.entity303.serversystem.main.ServerSystem;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MuteManager
extends ManagerMute {
    private final File muteFile;
    private final FileConfiguration cfg;
    private final String dateFormat;

    public MuteManager(File muteFile, String dateFormat, ServerSystem plugin) {
        super(muteFile, dateFormat, plugin);
        this.muteFile = muteFile;
        this.cfg = YamlConfiguration.loadConfiguration((File)muteFile);
        this.dateFormat = dateFormat;
    }

    @Override
    public void removeMute(UUID mutedUUID) {
        if (!this.isMuted(Bukkit.getOfflinePlayer((UUID)mutedUUID))) {
            return;
        }
        this.cfg.set("Muted." + mutedUUID, null);
        this.save();
        try {
            Mute mute = new Mute(null, null, null, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reload();
    }

    @Override
    public Mute addMute(UUID mutedUUID, String senderUUID, String reason, Long howLong, TimeUnit timeUnit) {
        if (this.isMuted(Bukkit.getOfflinePlayer((UUID)mutedUUID))) {
            this.removeMute(mutedUUID);
        }
        long unbanTime = System.currentTimeMillis() + howLong * timeUnit.getValue();
        if (howLong < 1L) {
            unbanTime = -1L;
        }
        this.cfg.set("Muted." + mutedUUID + ".Sender", (Object)senderUUID);
        this.cfg.set("Muted." + mutedUUID + ".Reason", (Object)reason);
        this.cfg.set("Muted." + mutedUUID + ".Shadow", (Object)false);
        this.cfg.set("Muted." + mutedUUID + ".UnmuteTime", (Object)Long.toString(unbanTime));
        this.save();
        Mute mute = new Mute(mutedUUID.toString(), senderUUID, unbanTime, this.convertLongToDate(unbanTime), reason);
        this.reload();
        return mute;
    }

    @Override
    public Mute addMute(UUID mutedUUID, String senderUUID, String reason, boolean shadow, Long howLong, TimeUnit timeUnit) {
        if (this.isMuted(Bukkit.getOfflinePlayer((UUID)mutedUUID))) {
            this.removeMute(mutedUUID);
        }
        long unbanTime = System.currentTimeMillis() + howLong * timeUnit.getValue();
        if (howLong < 1L) {
            unbanTime = -1L;
        }
        this.cfg.set("Muted." + mutedUUID + ".Sender", (Object)senderUUID);
        this.cfg.set("Muted." + mutedUUID + ".Reason", (Object)"No reason when shadow");
        this.cfg.set("Muted." + mutedUUID + ".Shadow", (Object)shadow);
        this.cfg.set("Muted." + mutedUUID + ".UnmuteTime", (Object)Long.toString(unbanTime));
        this.save();
        Mute mute = new Mute(mutedUUID.toString(), senderUUID, unbanTime, this.convertLongToDate(unbanTime), reason, shadow);
        this.reload();
        return mute;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String convertLongToDate(Long l) {
        if (l < 1L) {
            return this.getBanSystem("PermaBan");
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(l);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd:kk:mm:ss");
        String[] dates = dateFormat.format(c.getTime()).split(":");
        String year = dates[0];
        String month = dates[1];
        String day = dates[2];
        String hour = dates[3];
        String minute = dates[4];
        String second = dates[5];
        if (month.chars().count() == 1L) {
            month = "0" + month;
        }
        if (day.chars().count() == 1L) {
            day = "0" + day;
        }
        if (hour.chars().count() == 1L) {
            hour = "0" + hour;
        }
        if (minute.chars().count() == 1L) {
            minute = "0" + minute;
        }
        if (second.chars().count() == 1L) {
            second = "0" + second;
        }
        return this.getDateFormat().replace("<YEAR>", year).replace("<MONTH>", month).replace("<DAY>", day).replace("<HOUR>", hour).replace("<MINUTE>", minute).replace("<SECOND>", second);
    }

    @Override
    public boolean isMuted(OfflinePlayer player) {
        if (!this.muteFile.exists()) {
            return false;
        }
        return this.getMute(player) != null;
    }

    @Override
    public List<String> getMutedPlayerNames() {
        if (this.cfg.getConfigurationSection("Muted") == null) {
            return new ArrayList<String>();
        }
        this.cfg.getConfigurationSection("Muted").getKeys(false);
        if (this.cfg.getConfigurationSection("Muted").getKeys(false).size() <= 0) {
            return new ArrayList<String>();
        }
        try {
            return this.cfg.getConfigurationSection("Muted").getKeys(false).stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid))).map(OfflinePlayer::getName).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Mute getMute(OfflinePlayer player) {
        return this.getMute(player.getUniqueId());
    }

    public Mute getMute(UUID uuid) {
        if (!this.muteFile.exists()) {
            return null;
        }
        try {
            long unmute_time;
            String str = "Muted." + uuid.toString() + ".";
            String uuidSender = this.cfg.getString(str + "Sender");
            String uuidMuted = uuid.toString();
            try {
                unmute_time = Long.parseLong(this.cfg.getString(str + "UnmuteTime"));
            }
            catch (NumberFormatException ignored) {
                return null;
            }
            String unmute_date = this.convertLongToDate(unmute_time);
            String reason = this.cfg.getString(str + "Reason");
            boolean shadow = this.cfg.getBoolean(str + "Shadow");
            if (uuidSender == null) {
                return null;
            }
            if (uuidMuted == null) {
                return null;
            }
            if (unmute_date == null) {
                return null;
            }
            if (reason == null) {
                return null;
            }
            Mute mute = shadow ? new Mute(uuidSender, uuidMuted, unmute_time, unmute_date, reason, true) : new Mute(uuidSender, uuidMuted, unmute_time, unmute_date, reason);
            return mute;
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    public void reload() {
        try {
            this.cfg.load(this.muteFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.cfg.save(this.muteFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

